/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.DefaultButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.KeyStroke;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.gui.statusbar.HoverSetStatusMouseHandler;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.jedit.keymap.Keymap;

public class EnhancedCheckBoxMenuItem
extends JCheckBoxMenuItem {
    private final ActionContext context;
    private String shortcut;
    private final String action;

    public EnhancedCheckBoxMenuItem(String label, String action, ActionContext context) {
        this.context = context;
        this.action = action;
        this.shortcut = GUIUtilities.getShortcutLabel(action, true);
        String toolTip = jEdit.getProperty(action + ".tooltip");
        if (toolTip != null) {
            this.setToolTipText(toolTip);
        }
        if (OperatingSystem.hasScreenMenuBar() && this.shortcut != null) {
            if (jEdit.getBooleanProperty("menu.multiShortcut", false)) {
                this.setText(label + " ( " + this.shortcut + " )");
            } else {
                this.setText(label);
                Keymap keymap = jEdit.getKeymapManager().getKeymap();
                String rawShortcut = keymap.getShortcut(action + ".shortcut");
                KeyStroke key = KeyEventTranslator.parseKeyStroke(rawShortcut);
                if (key != null) {
                    this.setAccelerator(key);
                }
            }
            this.shortcut = null;
        } else {
            this.setText(label);
        }
        if (action != null) {
            this.setEnabled(true);
            this.addActionListener(new EditAction.Wrapper(context, action));
            this.addMouseListener(new HoverSetStatusMouseHandler(action));
        } else {
            this.setEnabled(false);
        }
        this.setModel(new Model());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.shortcut != null) {
            FontMetrics fm = this.getFontMetrics(GUIUtilities.menuAcceleratorFont());
            d.width += fm.stringWidth(this.shortcut) + fm.stringWidth("AAAA");
        }
        return d;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.shortcut != null) {
            Graphics2D g2 = (Graphics2D)g;
            g.setFont(GUIUtilities.menuAcceleratorFont());
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(GUIUtilities.menuAcceleratorForeground(this.getModel().isArmed()));
            FontMetrics fm = g.getFontMetrics();
            Insets insets = this.getInsets();
            g.drawString(this.shortcut, this.getWidth() - (fm.stringWidth(this.shortcut) + insets.right + insets.left + 5), fm.getAscent() + insets.top);
        }
    }

    private class Model
    extends DefaultButtonModel {
        private Model() {
        }

        @Override
        public boolean isSelected() {
            if (!EnhancedCheckBoxMenuItem.this.isVisible()) {
                return false;
            }
            EditAction a = EnhancedCheckBoxMenuItem.this.context.getAction(EnhancedCheckBoxMenuItem.this.action);
            if (a == null) {
                Log.log(7, this, "Unknown action: " + EnhancedCheckBoxMenuItem.this.action);
                return false;
            }
            try {
                return a.isSelected(EnhancedCheckBoxMenuItem.this);
            }
            catch (Throwable t) {
                Log.log(9, this, t);
                return false;
            }
        }

        @Override
        public void setSelected(boolean b) {
        }
    }
}

