/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import org.gjt.sp.jedit.BufferHistory;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.manager.BufferManager;
import org.gjt.sp.jedit.menu.DynamicMenuProvider;
import org.gjt.sp.jedit.menu.MenuItemTextComparator;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class RecentFilesProvider
implements DynamicMenuProvider {
    @Override
    public boolean updateEveryTime() {
        return false;
    }

    @Override
    public void update(JMenu menu) {
        View view = GUIUtilities.getView(menu);
        ActionListener actionListener = evt -> {
            jEdit.openFile(view, evt.getActionCommand());
            view.getStatus().setMessage(null);
        };
        ChangeListener changeListener = e -> {
            JMenuItem menuItem = (JMenuItem)e.getSource();
            view.getStatus().setMessage(menuItem.isArmed() ? menuItem.getActionCommand() : null);
        };
        List<BufferHistory.Entry> recentVector = BufferHistory.getHistory();
        if (recentVector.isEmpty()) {
            JMenuItem menuItem = new JMenuItem(jEdit.getProperty("no-recent-files.label"));
            menuItem.setEnabled(false);
            menu.add(menuItem);
            return;
        }
        final ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        final JTextField text = new JTextField();
        text.setToolTipText(jEdit.getProperty("recent-files.textfield.tooltip") + ": " + jEdit.getProperty("glob.tooltip"));
        text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String typedText = text.getText();
                boolean filter = !typedText.isEmpty();
                Pattern pattern = null;
                if (filter) {
                    Object regex = typedText;
                    if (!typedText.contains("*") && !typedText.contains("?")) {
                        regex = (String)regex + "*";
                    }
                    pattern = Pattern.compile(StandardUtilities.globToRE((String)regex), 2);
                }
                try {
                    for (JMenuItem recent : menuItems) {
                        recent.setEnabled(!filter || pattern.matcher(recent.getText()).matches());
                    }
                }
                catch (PatternSyntaxException re) {
                    Log.log(9, this, re.getMessage());
                }
            }
        });
        boolean sort = jEdit.getBooleanProperty("sortRecent");
        int maxItems = jEdit.getIntegerProperty("menu.spillover", 20);
        Iterator<BufferHistory.Entry> iter = recentVector.iterator();
        BufferManager bufferManager = jEdit.getBufferManager();
        while (iter.hasNext()) {
            String path = iter.next().path;
            if (jEdit.getBooleanProperty("hideOpen") && bufferManager.getBuffer(path).isPresent()) continue;
            JMenuItem menuItem = new JMenuItem(MiscUtilities.getFileName(path));
            menuItem.setToolTipText(path);
            menuItem.setActionCommand(path);
            menuItem.addActionListener(actionListener);
            menuItem.addChangeListener(changeListener);
            menuItem.setIcon(FileCellRenderer.fileIcon);
            menuItems.add(menuItem);
            if (sort) continue;
            if (menu.getMenuComponentCount() >= maxItems && iter.hasNext()) {
                JMenu newMenu = new JMenu(jEdit.getProperty("common.more"));
                menu.add(newMenu);
                menu = newMenu;
            }
            menu.add(menuItem);
        }
        if (sort) {
            menuItems.sort(new MenuItemTextComparator());
            for (int i = 0; i < menuItems.size(); ++i) {
                if (menu.getMenuComponentCount() >= maxItems && i != 0) {
                    JMenu newMenu = new JMenu(jEdit.getProperty("common.more"));
                    menu.add(newMenu);
                    menu = newMenu;
                }
                menu.add((JMenuItem)menuItems.get(i));
            }
        }
        JMenuItem menuItem = new JMenuItem(jEdit.getProperty("clear-recent-files.label"));
        menuItem.addActionListener(e -> BufferHistory.clear());
        menu.addSeparator();
        menu.add(menuItem);
    }
}

