/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.ColorChooserDialog;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.SyntaxHiliteOptionPane;
import org.gjt.sp.util.GenericGUIUtilities;

public class BrowserColorsOptionPane
extends AbstractOptionPane {
    private BrowserColorsModel colorsModel;
    private JTable colorsTable;
    private JButton remove;
    private JButton moveUp;
    private JButton moveDown;

    public BrowserColorsOptionPane() {
        super("browser.colors");
    }

    @Override
    protected void _init() {
        this.setLayout(new BorderLayout());
        this.colorsModel = new BrowserColorsModel();
        this.colorsTable = new JTable(this.colorsModel);
        this.colorsTable.setRowHeight(GenericGUIUtilities.defaultRowHeight());
        this.colorsTable.setAutoResizeMode(4);
        this.colorsTable.getTableHeader().setReorderingAllowed(false);
        this.colorsTable.addMouseListener(new MouseHandler());
        this.colorsTable.getSelectionModel().addListSelectionListener(e -> this.updateEnabled());
        TableColumnModel tcm = this.colorsTable.getColumnModel();
        tcm.getColumn(1).setCellRenderer(new BrowserColorsModel.ColorRenderer());
        Dimension d = this.colorsTable.getPreferredSize();
        d.height = Math.min(d.height, 200);
        JScrollPane scroller = new JScrollPane(this.colorsTable);
        scroller.setPreferredSize(d);
        this.add("Center", scroller);
        JPanel buttons = new JPanel();
        buttons.setBorder(new EmptyBorder(3, 0, 0, 0));
        buttons.setLayout(new BoxLayout(buttons, 0));
        ActionHandler actionHandler = new ActionHandler();
        RolloverButton add = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("common.add.icon")));
        add.setToolTipText(jEdit.getProperty("common.add"));
        add.addActionListener(e -> this.colorsModel.add());
        buttons.add(add);
        buttons.add(Box.createHorizontalStrut(6));
        this.remove = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("common.remove.icon")));
        this.remove.setToolTipText(jEdit.getProperty("common.remove"));
        this.remove.addActionListener(e -> {
            int selectedRow = this.colorsTable.getSelectedRow();
            this.colorsModel.remove(selectedRow);
            this.updateEnabled();
        });
        buttons.add(this.remove);
        buttons.add(Box.createHorizontalStrut(6));
        this.moveUp = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("common.moveUp.icon")));
        this.moveUp.setToolTipText(jEdit.getProperty("common.moveUp"));
        this.moveUp.addActionListener(actionHandler);
        buttons.add(this.moveUp);
        buttons.add(Box.createHorizontalStrut(6));
        this.moveDown = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("common.moveDown.icon")));
        this.moveDown.setToolTipText(jEdit.getProperty("common.moveDown"));
        this.moveDown.addActionListener(actionHandler);
        buttons.add(this.moveDown);
        buttons.add(Box.createGlue());
        this.add("South", buttons);
        this.updateEnabled();
    }

    @Override
    protected void _save() {
        this.colorsModel.save();
    }

    private void updateEnabled() {
        int selectedRow = this.colorsTable.getSelectedRow();
        this.remove.setEnabled(selectedRow != -1);
        this.moveUp.setEnabled(selectedRow > 0);
        this.moveDown.setEnabled(selectedRow != -1 && selectedRow != this.colorsModel.getRowCount() - 1);
    }

    private void setSelectedRow(int row) {
        this.colorsTable.getSelectionModel().setSelectionInterval(row, row);
        this.colorsTable.scrollRectToVisible(this.colorsTable.getCellRect(row, 0, true));
    }

    private static class BrowserColorsModel
    extends AbstractTableModel {
        private final List<Entry> entries = new ArrayList<Entry>();

        BrowserColorsModel() {
            String glob;
            int i = 0;
            while ((glob = jEdit.getProperty("vfs.browser.colors." + i + ".glob")) != null) {
                this.entries.add(new Entry(glob, jEdit.getColorProperty("vfs.browser.colors." + i + ".color")));
                ++i;
            }
        }

        void add() {
            this.entries.add(new Entry("", UIManager.getColor("Tree.foreground")));
            this.fireTableRowsInserted(this.entries.size() - 1, this.entries.size() - 1);
        }

        void remove(int index) {
            this.entries.remove(index);
            this.fireTableRowsDeleted(this.entries.size(), this.entries.size());
        }

        public void moveUp(int index) {
            Entry entry = this.entries.get(index);
            this.entries.remove(index);
            this.entries.add(index - 1, entry);
            this.fireTableRowsUpdated(index - 1, index);
        }

        public void moveDown(int index) {
            Entry entry = this.entries.get(index);
            this.entries.remove(index);
            this.entries.add(index + 1, entry);
            this.fireTableRowsUpdated(index, index + 1);
        }

        void save() {
            int i;
            for (i = 0; i < this.entries.size(); ++i) {
                Entry entry = this.entries.get(i);
                jEdit.setProperty("vfs.browser.colors." + i + ".glob", entry.glob);
                jEdit.setColorProperty("vfs.browser.colors." + i + ".color", entry.color);
            }
            jEdit.unsetProperty("vfs.browser.colors." + i + ".glob");
            jEdit.unsetProperty("vfs.browser.colors." + i + ".color");
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.entries.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Entry entry = this.entries.get(row);
            switch (col) {
                case 0: {
                    return entry.glob;
                }
                case 1: {
                    return entry.color;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Entry entry = this.entries.get(row);
            if (col == 0) {
                entry.glob = (String)value;
            } else {
                entry.color = (Color)value;
            }
            this.fireTableRowsUpdated(row, row);
        }

        @Override
        public String getColumnName(int index) {
            switch (index) {
                case 0: {
                    return jEdit.getProperty("options.browser.colors.glob");
                }
                case 1: {
                    return jEdit.getProperty("options.browser.colors.color");
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Color.class;
                }
            }
            throw new InternalError();
        }

        private static class Entry {
            String glob;
            Color color;

            Entry(String glob, Color color) {
                this.glob = glob;
                this.color = color;
            }
        }

        private static class ColorRenderer
        extends JLabel
        implements TableCellRenderer {
            ColorRenderer() {
                this.setOpaque(true);
                this.setBorder(SyntaxHiliteOptionPane.noFocusBorder);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int col) {
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                    this.setForeground(table.getSelectionForeground());
                } else {
                    this.setBackground(table.getBackground());
                    this.setForeground(table.getForeground());
                }
                if (value != null) {
                    this.setBackground((Color)value);
                }
                this.setBorder(cellHasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : SyntaxHiliteOptionPane.noFocusBorder);
                return this;
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            Point p = evt.getPoint();
            int row = BrowserColorsOptionPane.this.colorsTable.rowAtPoint(p);
            int column = BrowserColorsOptionPane.this.colorsTable.columnAtPoint(p);
            if (row == -1 || column != 1) {
                return;
            }
            ColorChooserDialog dialog = new ColorChooserDialog((Window)SwingUtilities.getRoot(BrowserColorsOptionPane.this), (Color)BrowserColorsOptionPane.this.colorsModel.getValueAt(row, 1));
            Color color = dialog.getColor();
            if (color != null) {
                BrowserColorsOptionPane.this.colorsModel.setValueAt(color, row, 1);
            }
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == BrowserColorsOptionPane.this.moveUp) {
                int selectedRow = BrowserColorsOptionPane.this.colorsTable.getSelectedRow();
                if (selectedRow != 0) {
                    BrowserColorsOptionPane.this.colorsModel.moveUp(selectedRow);
                    BrowserColorsOptionPane.this.setSelectedRow(selectedRow - 1);
                }
                BrowserColorsOptionPane.this.updateEnabled();
            } else if (source == BrowserColorsOptionPane.this.moveDown) {
                int selectedRow = BrowserColorsOptionPane.this.colorsTable.getSelectedRow();
                if (selectedRow != BrowserColorsOptionPane.this.colorsTable.getRowCount() - 1) {
                    BrowserColorsOptionPane.this.colorsModel.moveDown(selectedRow);
                    BrowserColorsOptionPane.this.setSelectedRow(selectedRow + 1);
                }
                BrowserColorsOptionPane.this.updateEnabled();
            }
        }
    }
}

