/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.gui.ColorWellButton;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;

public class StatusBarOptionPane
extends AbstractOptionPane {
    private WidgetTableModel widgetTableModel;
    private ColorWellButton foregroundColor;
    private ColorWellButton backgroundColor;
    private ColorWellButton memForegroundColor;
    private ColorWellButton memBackgroundColor;
    private JCheckBox showStatusbar;
    private JCheckBox showStatusbarPlain;
    private JTable widgetTable;
    private RolloverButton moveUp;
    private RolloverButton moveDown;
    private JCheckBox showCaretLineNumber;
    private JCheckBox showCaretDot;
    private JCheckBox showCaretVirtual;
    private JCheckBox showCaretOffset;
    private JCheckBox showCaretBufferLength;

    public StatusBarOptionPane() {
        super("status");
    }

    @Override
    protected void _init() {
        this.setLayout(new BorderLayout());
        JPanel checkboxPanel = new JPanel(new GridLayout(2, 1));
        this.showStatusbar = new JCheckBox(jEdit.getProperty("options.status.visible"));
        this.showStatusbar.setSelected(jEdit.getBooleanProperty("view.status.visible"));
        checkboxPanel.add(this.showStatusbar);
        this.showStatusbarPlain = new JCheckBox(jEdit.getProperty("options.status.plainview.visible"));
        this.showStatusbarPlain.setSelected(jEdit.getBooleanProperty("view.status.plainview.visible"));
        checkboxPanel.add(this.showStatusbarPlain);
        checkboxPanel.add(new JLabel(jEdit.getProperty("options.status.caption")));
        JPanel north = new JPanel(new GridLayout(2, 1));
        north.add(checkboxPanel);
        this.add((Component)north, "North");
        AbstractOptionPane optionsPanel = new AbstractOptionPane("Status Options");
        this.foregroundColor = new ColorWellButton(jEdit.getColorProperty("view.status.foreground"));
        optionsPanel.addComponent(jEdit.getProperty("options.status.foreground"), (Component)this.foregroundColor, 3);
        this.backgroundColor = new ColorWellButton(jEdit.getColorProperty("view.status.background"));
        optionsPanel.addComponent(jEdit.getProperty("options.status.background"), (Component)this.backgroundColor, 3);
        this.memForegroundColor = new ColorWellButton(jEdit.getColorProperty("view.status.memory.foreground"));
        optionsPanel.addComponent(jEdit.getProperty("options.status.memory.foreground"), (Component)this.memForegroundColor, 3);
        this.memBackgroundColor = new ColorWellButton(jEdit.getColorProperty("view.status.memory.background"));
        optionsPanel.addComponent(jEdit.getProperty("options.status.memory.background"), (Component)this.memBackgroundColor, 3);
        optionsPanel.addSeparator();
        optionsPanel.addComponent(new JLabel(jEdit.getProperty("options.status.caret.title", "Caret position display options:")));
        this.showCaretLineNumber = new JCheckBox(jEdit.getProperty("options.status.caret.linenumber", "Show caret line number"), jEdit.getBooleanProperty("view.status.show-caret-linenumber", true));
        this.showCaretLineNumber.setName("showCaretLineNumber");
        this.showCaretDot = new JCheckBox(jEdit.getProperty("options.status.caret.dot", "Show caret offset from start of line"), jEdit.getBooleanProperty("view.status.show-caret-dot", true));
        this.showCaretDot.setName("showCaretDot");
        this.showCaretVirtual = new JCheckBox(jEdit.getProperty("options.status.caret.virtual", "Show caret virtual offset from start of line"), jEdit.getBooleanProperty("view.status.show-caret-virtual", true));
        this.showCaretVirtual.setName("showCaretVirtual");
        this.showCaretOffset = new JCheckBox(jEdit.getProperty("options.status.caret.offset", "Show caret offset from start of file"), jEdit.getBooleanProperty("view.status.show-caret-offset", true));
        this.showCaretOffset.setName("showCaretOffset");
        this.showCaretBufferLength = new JCheckBox(jEdit.getProperty("options.status.caret.bufferlength", "Show length of file"), jEdit.getBooleanProperty("view.status.show-caret-bufferlength", true));
        this.showCaretBufferLength.setName("showCaretBufferLength");
        optionsPanel.addComponent(this.showCaretLineNumber);
        optionsPanel.addComponent(this.showCaretDot);
        optionsPanel.addComponent(this.showCaretVirtual);
        optionsPanel.addComponent(this.showCaretOffset);
        optionsPanel.addComponent(this.showCaretBufferLength);
        this.widgetTableModel = new WidgetTableModel();
        this.widgetTable = new JTable(this.widgetTableModel);
        this.widgetTable.setDefaultRenderer(WidgetTableModel.TableEntry.class, new WidgetCellRenderer());
        this.widgetTable.setSelectionMode(0);
        this.widgetTable.setTableHeader(null);
        this.widgetTable.getSelectionModel().addListSelectionListener(e -> this.updateButtons());
        JPanel widgetsPanel = new JPanel(new BorderLayout());
        widgetsPanel.add((Component)new JScrollPane(this.widgetTable), "Center");
        JPanel buttons = new JPanel();
        buttons.setBorder(new EmptyBorder(3, 0, 0, 0));
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(Box.createHorizontalStrut(6));
        this.moveUp = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("common.moveUp.icon")));
        this.moveUp.setToolTipText(jEdit.getProperty("options.status.moveUp"));
        this.moveUp.addActionListener(e -> this.moveUp());
        buttons.add(this.moveUp);
        buttons.add(Box.createHorizontalStrut(6));
        this.moveDown = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("common.moveDown.icon")));
        this.moveDown.setToolTipText(jEdit.getProperty("options.status.moveDown"));
        this.moveDown.addActionListener(e -> this.moveDown());
        buttons.add(this.moveDown);
        buttons.add(Box.createHorizontalStrut(6));
        buttons.add(Box.createGlue());
        widgetsPanel.add((Component)buttons, "South");
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("Options", optionsPanel);
        tabs.add("Widgets", widgetsPanel);
        this.add((Component)tabs, "Center");
        this.updateButtons();
    }

    @Override
    protected void _save() {
        jEdit.setColorProperty("view.status.foreground", this.foregroundColor.getSelectedColor());
        jEdit.setColorProperty("view.status.background", this.backgroundColor.getSelectedColor());
        jEdit.setColorProperty("view.status.memory.foreground", this.memForegroundColor.getSelectedColor());
        jEdit.setColorProperty("view.status.memory.background", this.memBackgroundColor.getSelectedColor());
        jEdit.setBooleanProperty("view.status.visible", this.showStatusbar.isSelected());
        jEdit.setBooleanProperty("view.status.plainview.visible", this.showStatusbarPlain.isSelected());
        this.saveWidgets("view.status-leading", WidgetTableModel.TableEntry::isSelectedLeading);
        this.saveWidgets("view.status", WidgetTableModel.TableEntry::isSelectedTrailing);
        jEdit.setBooleanProperty("view.status.show-caret-linenumber", this.showCaretLineNumber.isSelected());
        jEdit.setBooleanProperty("view.status.show-caret-dot", this.showCaretDot.isSelected());
        jEdit.setBooleanProperty("view.status.show-caret-virtual", this.showCaretVirtual.isSelected());
        jEdit.setBooleanProperty("view.status.show-caret-offset", this.showCaretOffset.isSelected());
        jEdit.setBooleanProperty("view.status.show-caret-bufferlength", this.showCaretBufferLength.isSelected());
    }

    private void saveWidgets(String propertyName, Predicate<WidgetTableModel.TableEntry> filter) {
        CharSequence[] tokens = (String[])StreamSupport.stream(this.widgetTableModel.spliterator(), false).filter(filter).map(WidgetTableModel.TableEntry::getWidget).toArray(String[]::new);
        jEdit.setProperty(propertyName, String.join((CharSequence)" ", tokens));
    }

    private void updateButtons() {
        int index = this.widgetTable.getSelectedRow();
        this.moveUp.setEnabled(index > 0);
        this.moveDown.setEnabled(index != -1 && index != this.widgetTable.getRowCount() - 1);
    }

    private void moveUp() {
        int index = this.widgetTable.getSelectedRow();
        this.widgetTableModel.moveUp(index);
        this.widgetTable.getSelectionModel().setSelectionInterval(index - 1, index - 1);
    }

    private void moveDown() {
        int index = this.widgetTable.getSelectedRow();
        this.widgetTableModel.moveDown(index);
        this.widgetTable.getSelectionModel().setSelectionInterval(index + 1, index + 1);
    }

    private static class WidgetTableModel
    extends AbstractTableModel
    implements Iterable<TableEntry> {
        private final List<TableEntry> widgets;

        WidgetTableModel() {
            String[] usedTrailingWidgets;
            String[] usedleadingWidgets;
            Object[] allWidgets = ServiceManager.getServiceNames(StatusWidgetFactory.class);
            Arrays.sort(allWidgets);
            ArrayList<Object> allWidgetsList = new ArrayList<Object>(Arrays.asList(allWidgets));
            this.widgets = new ArrayList<TableEntry>();
            String leadingStatusBar = jEdit.getProperty("view.status-leading");
            String trailingStatusBar = jEdit.getProperty("view.status");
            for (String usedWidget : usedleadingWidgets = leadingStatusBar.split(" ")) {
                if (!allWidgetsList.remove(usedWidget)) continue;
                this.widgets.add(new TableEntry(usedWidget, true, false));
            }
            for (String usedWidget : usedTrailingWidgets = trailingStatusBar.split(" ")) {
                if (!allWidgetsList.remove(usedWidget)) continue;
                this.widgets.add(new TableEntry(usedWidget, false, true));
            }
            allWidgetsList.stream().map(widget -> new TableEntry((String)widget, false, false)).forEach(this.widgets::add);
        }

        @Override
        @Nonnull
        public Iterator<TableEntry> iterator() {
            return this.widgets.iterator();
        }

        void moveUp(int index) {
            TableEntry entry = this.widgets.remove(index);
            this.widgets.add(index - 1, entry);
            this.fireTableRowsUpdated(index - 1, index);
        }

        void moveDown(int index) {
            TableEntry entry = this.widgets.remove(index);
            this.widgets.add(index + 1, entry);
            this.fireTableRowsUpdated(index, index + 1);
        }

        @Override
        public int getRowCount() {
            return this.widgets.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 || columnIndex == 1;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            TableEntry tableEntry = this.widgets.get(rowIndex);
            if (columnIndex == 0) {
                tableEntry.setSelectedLeading((Boolean)aValue);
                tableEntry.setSelectedTrailing(false);
            } else if (columnIndex == 1) {
                tableEntry.setSelectedLeading(false);
                tableEntry.setSelectedTrailing((Boolean)aValue);
            }
            this.fireTableCellUpdated(rowIndex, 0);
            this.fireTableCellUpdated(rowIndex, 1);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 1: {
                    return Boolean.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return TableEntry.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TableEntry tableEntry = this.widgets.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return tableEntry.isSelectedLeading();
                }
                case 1: {
                    return tableEntry.isSelectedTrailing();
                }
                case 2: {
                    return tableEntry.getWidget();
                }
            }
            return tableEntry;
        }

        private static class TableEntry {
            private boolean selectedLeading;
            private boolean selectedTrailing;
            private String widget;

            private TableEntry(String widget, boolean selectedLeading, boolean selectedTrailing) {
                this.widget = widget;
                this.selectedLeading = selectedLeading;
                this.selectedTrailing = selectedTrailing;
            }

            public boolean isSelectedLeading() {
                return this.selectedLeading;
            }

            public void setSelectedLeading(boolean selectedLeading) {
                this.selectedLeading = selectedLeading;
            }

            public boolean isSelectedTrailing() {
                return this.selectedTrailing;
            }

            public void setSelectedTrailing(boolean selectedTrailing) {
                this.selectedTrailing = selectedTrailing;
            }

            public String getWidget() {
                return this.widget;
            }

            public void setWidget(String widget) {
                this.widget = widget;
            }
        }
    }

    private static class WidgetCellRenderer
    extends DefaultTableCellRenderer {
        private final Map<String, JComponent> widgetsSamples = new HashMap<String, JComponent>();

        private WidgetCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            WidgetTableModel.TableEntry tableEntry = (WidgetTableModel.TableEntry)value;
            String widgetName = tableEntry.getWidget();
            JComponent widgetComponent = this.widgetsSamples.get(widgetName);
            if (widgetComponent == null) {
                StatusWidgetFactory service = ServiceManager.getService(StatusWidgetFactory.class, widgetName);
                if (service != null) {
                    Widget widget = service.getWidget(jEdit.getActiveView());
                    widget.update();
                    widgetComponent = widget.getComponent();
                    this.widgetsSamples.put(widgetName, widgetComponent);
                } else {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    String label = jEdit.getProperty("statusbar." + widgetName + ".label", widgetName);
                    this.setText(label);
                    widgetComponent = this;
                }
            }
            return widgetComponent;
        }
    }
}

