/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.ToolBarOptionPane;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

class ToolBarEditDialog
extends EnhancedDialog {
    private boolean isOK;
    private final JRadioButton separator;
    private final JRadioButton action;
    private final JComboBox<ActionSet> combo;
    private final JList<ToolBarOptionPane.Button> list;
    private final JRadioButton builtin;
    private final JComboBox<ToolBarOptionPane.IconListEntry> builtinCombo;
    private final JRadioButton file;
    private final JButton fileButton;
    private String fileIcon;

    ToolBarEditDialog(Component comp, DefaultComboBoxModel<ToolBarOptionPane.IconListEntry> iconListModel, ToolBarOptionPane.Button current) {
        super(GenericGUIUtilities.getParentDialog(comp), jEdit.getProperty("options.toolbar.edit.title"), true);
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        ButtonGroup grp = new ButtonGroup();
        JPanel typePanel = new JPanel(new GridLayout(3, 1, 6, 6));
        typePanel.setBorder(new EmptyBorder(0, 0, 6, 0));
        typePanel.add(new JLabel(jEdit.getProperty("options.toolbar.edit.caption")));
        this.separator = new JRadioButton(jEdit.getProperty("options.toolbar.edit.separator"));
        this.separator.addActionListener(e -> this.updateEnabled());
        grp.add(this.separator);
        typePanel.add(this.separator);
        this.action = new JRadioButton(jEdit.getProperty("options.toolbar.edit.action"));
        this.action.addActionListener(e -> this.updateEnabled());
        grp.add(this.action);
        typePanel.add(this.action);
        content.add("North", typePanel);
        JPanel actionPanel = new JPanel(new BorderLayout(6, 6));
        ActionSet[] actionsList = jEdit.getActionSets();
        String selectedActionSet = jEdit.getProperty("options.toolbar.selectedActionSet");
        ActionSet selectedItem = null;
        Vector<ActionSet> vec = new Vector<ActionSet>(actionsList.length);
        for (ActionSet actionSet : actionsList) {
            if (actionSet.getActionCount() == 0) continue;
            vec.add(actionSet);
            if (!actionSet.getLabel().equals(selectedActionSet)) continue;
            selectedItem = actionSet;
        }
        vec.sort((o1, o2) -> StandardUtilities.compareStrings(o1.getLabel(), o2.getLabel(), false));
        this.combo = new JComboBox(vec);
        if (selectedItem != null) {
            this.combo.setSelectedItem(selectedItem);
        } else {
            jEdit.unsetProperty("options.toolbar.selectedActionSet");
        }
        this.combo.addActionListener(e -> this.updateList());
        actionPanel.add("North", this.combo);
        this.list = new JList();
        this.list.setVisibleRowCount(8);
        this.list.setSelectionMode(0);
        actionPanel.add("Center", new JScrollPane(this.list));
        JPanel iconPanel = new JPanel(new BorderLayout(0, 3));
        JPanel labelPanel = new JPanel(new GridLayout(2, 1));
        labelPanel.setBorder(new EmptyBorder(0, 0, 0, 12));
        JPanel compPanel = new JPanel(new GridLayout(2, 1));
        grp = new ButtonGroup();
        this.builtin = new JRadioButton(jEdit.getProperty("options.toolbar.edit.builtin"));
        labelPanel.add(this.builtin);
        this.builtin.addActionListener(e -> this.updateEnabled());
        grp.add(this.builtin);
        this.file = new JRadioButton(jEdit.getProperty("options.toolbar.edit.file"));
        labelPanel.add(this.file);
        grp.add(this.file);
        this.file.addActionListener(e -> this.updateEnabled());
        iconPanel.add("West", labelPanel);
        this.builtinCombo = new JComboBox<ToolBarOptionPane.IconListEntry>(iconListModel);
        this.builtinCombo.setRenderer(new ToolBarOptionPane.IconCellRenderer());
        compPanel.add(this.builtinCombo);
        this.fileButton = new JButton(jEdit.getProperty("options.toolbar.edit.no-icon"));
        this.fileButton.setMargin(new Insets(1, 1, 1, 1));
        this.fileButton.setIcon(GUIUtilities.loadIcon("Blank24.gif"));
        this.fileButton.setHorizontalAlignment(2);
        this.fileButton.addActionListener(e -> this.browseIcon());
        compPanel.add(this.fileButton);
        iconPanel.add("Center", compPanel);
        actionPanel.add("South", iconPanel);
        content.add("Center", actionPanel);
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BoxLayout(southPanel, 0));
        southPanel.setBorder(new EmptyBorder(17, 0, 0, 0));
        JButton ok = new JButton(jEdit.getProperty("common.ok"));
        ok.addActionListener(e -> this.ok());
        this.getRootPane().setDefaultButton(ok);
        JButton cancel = new JButton(jEdit.getProperty("common.cancel"));
        cancel.addActionListener(e -> this.cancel());
        GenericGUIUtilities.makeSameSize(ok, cancel);
        southPanel.add(Box.createGlue());
        southPanel.add(ok);
        southPanel.add(Box.createHorizontalStrut(6));
        southPanel.add(cancel);
        content.add("South", southPanel);
        if (current == null) {
            this.action.setSelected(true);
            this.builtin.setSelected(true);
            this.updateList();
        } else if ("-".equals(current.actionName)) {
            this.separator.setSelected(true);
            this.builtin.setSelected(true);
        } else {
            this.action.setSelected(true);
            ActionSet set = jEdit.getActionSetForAction(current.actionName);
            this.combo.setSelectedItem(set);
            this.updateList();
            this.list.setSelectedValue(current, true);
            if (MiscUtilities.isURL(current.iconName)) {
                this.file.setSelected(true);
                this.fileIcon = current.iconName;
                try {
                    this.fileButton.setIcon(new ImageIcon(new URL(this.fileIcon)));
                }
                catch (MalformedURLException mf) {
                    Log.log(9, this, mf);
                }
                this.fileButton.setText(MiscUtilities.getFileName(this.fileIcon));
            } else {
                this.builtin.setSelected(true);
                ComboBoxModel<ToolBarOptionPane.IconListEntry> model = this.builtinCombo.getModel();
                for (int i = 0; i < model.getSize(); ++i) {
                    ToolBarOptionPane.IconListEntry entry = (ToolBarOptionPane.IconListEntry)model.getElementAt(i);
                    if (!entry.name.equals(current.iconName)) continue;
                    this.builtinCombo.setSelectedIndex(i);
                    break;
                }
            }
        }
        this.updateEnabled();
        this.pack();
        this.setLocationRelativeTo(GenericGUIUtilities.getParentDialog(comp));
        this.setVisible(true);
    }

    @Override
    public void ok() {
        this.isOK = true;
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    public ToolBarOptionPane.Button getSelection() {
        String iconName;
        Icon icon;
        if (!this.isOK) {
            return null;
        }
        if (this.separator.isSelected()) {
            return new ToolBarOptionPane.Button("-", null, null, "-");
        }
        if (this.builtin.isSelected()) {
            ToolBarOptionPane.IconListEntry selectedIcon = (ToolBarOptionPane.IconListEntry)this.builtinCombo.getSelectedItem();
            icon = selectedIcon.icon;
            iconName = selectedIcon.name;
        } else {
            icon = this.fileButton.getIcon();
            iconName = this.fileIcon;
            if (iconName == null) {
                iconName = "Blank24.gif";
            }
        }
        if (!this.action.isSelected()) {
            throw new InternalError();
        }
        ToolBarOptionPane.Button button = this.list.getSelectedValue();
        String label = button.label;
        String actionName = button.actionName;
        return new ToolBarOptionPane.Button(actionName, iconName, icon, label);
    }

    private void updateEnabled() {
        this.combo.setEnabled(this.action.isSelected());
        this.list.setEnabled(this.action.isSelected());
        boolean iconControlsEnabled = !this.separator.isSelected();
        this.builtin.setEnabled(iconControlsEnabled);
        this.file.setEnabled(iconControlsEnabled);
        this.builtinCombo.setEnabled(iconControlsEnabled && this.builtin.isSelected());
        this.fileButton.setEnabled(iconControlsEnabled && this.file.isSelected());
    }

    private void updateList() {
        ActionSet actionSet = (ActionSet)this.combo.getSelectedItem();
        String actionSetLabel = actionSet.getLabel();
        jEdit.setProperty("options.toolbar.selectedActionSet", actionSetLabel);
        EditAction[] actions = actionSet.getActions();
        Vector<ToolBarOptionPane.Button> listModel = new Vector<ToolBarOptionPane.Button>(actions.length);
        for (EditAction action : actions) {
            String label = action.getLabel();
            if (label == null) continue;
            listModel.add(new ToolBarOptionPane.Button(action.getName(), null, null, label));
        }
        listModel.sort((button1, button2) -> StandardUtilities.compareStrings(button1.label, button2.label, true));
        this.list.setListData(listModel);
    }

    private void browseIcon() {
        String directory = this.fileIcon == null ? null : MiscUtilities.getParentOfPath(this.fileIcon);
        String[] paths = GUIUtilities.showVFSFileDialog(null, directory, 0, false);
        if (paths.length == 0) {
            return;
        }
        this.fileIcon = "file:" + paths[0];
        try {
            this.fileButton.setIcon(new ImageIcon(new URL(this.fileIcon)));
        }
        catch (MalformedURLException mf) {
            Log.log(9, this, mf);
        }
        this.fileButton.setText(MiscUtilities.getFileName(this.fileIcon));
    }
}

