/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.CachePluginList;
import org.gjt.sp.jedit.pluginmgr.PluginListHandler;
import org.gjt.sp.jedit.pluginmgr.RemotePluginList;
import org.gjt.sp.jedit.pluginmgr.Roster;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.ThreadUtilities;
import org.jedit.io.HttpException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class PluginList
extends Task {
    final List<Plugin> plugins = new ArrayList<Plugin>();
    final Map<String, Plugin> pluginHash = new HashMap<String, Plugin>();
    final List<PluginSet> pluginSets = new ArrayList<PluginSet>();
    private String id;
    private final Runnable dispatchThreadTask;

    PluginList(Runnable dispatchThreadTask) {
        this.dispatchThreadTask = dispatchThreadTask;
    }

    @Override
    public void _run() {
        this.id = jEdit.getProperty("plugin-manager.mirror.id");
        CachePluginList cachePluginList = new CachePluginList(this.id);
        RemotePluginList remotePluginList = new RemotePluginList(this, this.id);
        this.setStatus(jEdit.getProperty("plugin-manager.list-download-connect"));
        try {
            Optional<String> pluginListXml = cachePluginList.getPluginList();
            boolean loadedFromCache = false;
            if (pluginListXml.isPresent()) {
                try {
                    this.loadPluginList(pluginListXml.get());
                    loadedFromCache = true;
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    cachePluginList.deleteCache();
                }
            }
            if (!loadedFromCache) {
                String newPluginList = remotePluginList.getPluginList();
                this.loadPluginList(newPluginList);
                cachePluginList.saveCache(newPluginList);
            }
        }
        catch (HttpException e) {
            int responseCode = e.getResponseCode();
            if (responseCode == 407) {
                Log.log(9, this, "CacheRemotePluginList: proxy requires authentication");
                ThreadUtilities.runInDispatchThread(() -> GUIUtilities.error(jEdit.getActiveView(), "plugin-manager.list-download.need-password", new Object[0]));
            } else {
                String responseMessage = e.getMessage();
                Log.log(9, this, "CacheRemotePluginList: HTTP error: " + responseCode + " " + responseMessage);
                ThreadUtilities.runInDispatchThread(() -> GUIUtilities.error(jEdit.getActiveView(), "plugin-manager.list-download.generic-error", new Object[]{responseCode, responseMessage}));
            }
        }
        catch (Exception e) {
            Log.log(9, this, "CacheRemotePluginList: error", e);
            ThreadUtilities.runInDispatchThread(() -> GUIUtilities.error(jEdit.getActiveView(), "plugin-manager.list-download.disconnected", new Object[]{e.getMessage()}));
        }
        ThreadUtilities.runInDispatchThread(this.dispatchThreadTask);
    }

    private void loadPluginList(String pluginListXml) throws IOException, SAXException, ParserConfigurationException {
        PluginListHandler handler = new PluginListHandler(this);
        XMLReader parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        InputSource isrc = new InputSource(new StringReader(pluginListXml));
        isrc.setSystemId("jedit.jar");
        parser.setContentHandler(handler);
        parser.setDTDHandler(handler);
        parser.setEntityResolver(handler);
        parser.setErrorHandler(handler);
        parser.parse(isrc);
    }

    void addPlugin(Plugin plugin) {
        this.plugins.add(plugin);
        this.pluginHash.put(plugin.name, plugin);
    }

    void addPluginSet(PluginSet set) {
        this.pluginSets.add(set);
    }

    void finished() {
        for (Plugin plugin : this.plugins) {
            for (int j = 0; j < plugin.branches.size(); ++j) {
                Branch branch = plugin.branches.get(j);
                for (int k = 0; k < branch.deps.size(); ++k) {
                    Dependency dep = branch.deps.get(k);
                    if (!dep.what.equals("plugin")) continue;
                    dep.plugin = this.pluginHash.get(dep.pluginName);
                }
            }
        }
    }

    void dump() {
        for (Plugin plugin : this.plugins) {
            System.err.println(plugin);
            System.err.println();
        }
    }

    String getMirrorId() {
        return this.id;
    }

    private static String getAutoSelectedMirror() throws IOException {
        String samplerUrl = "http://sourceforge.net/projects/jedit/files/latest/download";
        HttpURLConnection connection = (HttpURLConnection)new URL("http://sourceforge.net/projects/jedit/files/latest/download").openConnection();
        connection.setInstanceFollowRedirects(false);
        int response = connection.getResponseCode();
        if (response != 302) {
            throw new RuntimeException("Unexpected response: " + response + ": from http://sourceforge.net/projects/jedit/files/latest/download");
        }
        String redirected = connection.getHeaderField("Location");
        if (redirected == null) {
            throw new RuntimeException("Missing Location header: http://sourceforge.net/projects/jedit/files/latest/download");
        }
        String prefix = "use_mirror=";
        int found = redirected.lastIndexOf("use_mirror=");
        if (found == -1) {
            throw new RuntimeException("Mirror prefix \"use_mirror\" was not found in redirected URL: " + redirected);
        }
        int start = found + "use_mirror=".length();
        int end = redirected.indexOf(38, start);
        return end != -1 ? redirected.substring(start, end) : redirected.substring(start);
    }

    public static class Plugin {
        String jar;
        String name;
        String description;
        String author;
        final List<Branch> branches = new ArrayList<Branch>();
        String installedVersion = null;
        String installedPath = null;
        boolean loaded = false;

        String getInstalledVersion() {
            String[] notLoadedJars;
            this.loaded = false;
            PluginJAR[] jars = jEdit.getPluginJARs();
            for (int i = 0; i < jars.length; ++i) {
                String path = jars[i].getPath();
                if (!MiscUtilities.getFileName(path).equals(this.jar)) continue;
                EditPlugin plugin = jars[i].getPlugin();
                if (plugin != null) {
                    this.installedVersion = jEdit.getProperty("plugin." + plugin.getClassName() + ".version");
                    this.loaded = true;
                    return this.installedVersion;
                }
                return null;
            }
            for (String path : notLoadedJars = jEdit.getNotLoadedPluginJARs()) {
                if (!MiscUtilities.getFileName(path).equals(this.jar)) continue;
                try {
                    PluginJAR.PluginCacheEntry cacheEntry = PluginJAR.getPluginCacheEntry(path);
                    if (cacheEntry == null) continue;
                    String versionKey = "plugin." + cacheEntry.pluginClass + ".version";
                    this.installedVersion = cacheEntry.cachedProperties.getProperty(versionKey);
                    Log.log(1, PluginList.class, "found installed but not loaded " + this.jar + " version=" + this.installedVersion);
                    this.installedPath = path;
                    return this.installedVersion;
                }
                catch (IOException e) {
                    Log.log(7, "Unable to access cache for " + this.jar, e);
                }
            }
            return null;
        }

        String getInstalledPath() {
            if (this.installedPath != null) {
                if (new File(this.installedPath).exists()) {
                    return this.installedPath;
                }
                this.installedPath = null;
            }
            PluginJAR[] jars = jEdit.getPluginJARs();
            for (int i = 0; i < jars.length; ++i) {
                String path = jars[i].getPath();
                if (!MiscUtilities.getFileName(path).equals(this.jar)) continue;
                return path;
            }
            return null;
        }

        Branch getCompatibleBranch() {
            for (Branch branch : this.branches) {
                if (!branch.canSatisfyDependencies()) continue;
                return branch;
            }
            return null;
        }

        boolean canBeInstalled() {
            Branch branch = this.getCompatibleBranch();
            return branch != null && !branch.obsolete && branch.canSatisfyDependencies();
        }

        void install(Roster roster, String installDirectory, boolean downloadSource, boolean asDependency) {
            String installed = this.getInstalledPath();
            Branch branch = this.getCompatibleBranch();
            if (branch.obsolete) {
                if (installed != null) {
                    roster.addRemove(installed);
                }
                return;
            }
            if (this.installedVersion != null && this.installedPath != null && !this.loaded && asDependency) {
                roster.addLoad(this.installedPath);
                return;
            }
            if (installed != null) {
                installDirectory = MiscUtilities.getParentOfPath(installed);
            }
            roster.addInstall(installed, downloadSource ? branch.downloadSource : branch.download, installDirectory, downloadSource ? branch.downloadSourceSize : branch.downloadSize);
        }

        public String toString() {
            return this.name;
        }
    }

    static class Branch {
        String version;
        String date;
        int downloadSize;
        String download;
        int downloadSourceSize;
        String downloadSource;
        boolean obsolete;
        final List<Dependency> deps = new ArrayList<Dependency>();

        Branch() {
        }

        boolean canSatisfyDependencies() {
            for (Dependency dep : this.deps) {
                if (dep.canSatisfy()) continue;
                return false;
            }
            return true;
        }

        void satisfyDependencies(Roster roster, String installDirectory, boolean downloadSource) {
            this.deps.forEach(dep -> dep.satisfy(roster, installDirectory, downloadSource));
        }

        public String depsToString() {
            StringBuilder sb = new StringBuilder();
            for (Dependency dep : this.deps) {
                if (!"plugin".equals(dep.what) || dep.pluginName == null) continue;
                sb.append(dep.pluginName).append('\n');
            }
            return sb.toString();
        }

        public String toString() {
            return "[version=" + this.version + ",download=" + this.download + ",obsolete=" + this.obsolete + ",deps=" + String.valueOf(this.deps) + "]";
        }
    }

    static class Dependency {
        final String what;
        final String from;
        final String to;
        final String pluginName;
        Plugin plugin;

        Dependency(String what, String from, String to, String pluginName) {
            this.what = what;
            this.from = from;
            this.to = to;
            this.pluginName = pluginName;
        }

        boolean isSatisfied() {
            switch (this.what) {
                case "plugin": {
                    return this.isSatisfiedByPlugin();
                }
                case "jdk": {
                    return this.isSatisfiedByJdk();
                }
                case "jedit": {
                    return this.isSatisfiedByJEdit();
                }
            }
            Log.log(9, this, "Invalid dependency: " + this.what);
            return false;
        }

        private boolean isSatisfiedByJEdit() {
            String build = jEdit.getBuild();
            return !(this.from != null && StandardUtilities.compareStrings(build, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(build, this.to, false) > 0);
        }

        private boolean isSatisfiedByJdk() {
            String javaVersion = System.getProperty("java.version");
            javaVersion = javaVersion.length() >= 3 ? javaVersion.substring(0, 3) : javaVersion;
            return !(this.from != null && StandardUtilities.compareStrings(javaVersion, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(javaVersion, this.to, false) > 0);
        }

        private boolean isSatisfiedByPlugin() {
            for (int i = 0; i < this.plugin.branches.size(); ++i) {
                String installedVersion = this.plugin.getInstalledVersion();
                if (installedVersion == null || this.from != null && StandardUtilities.compareStrings(installedVersion, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(installedVersion, this.to, false) > 0) continue;
                return true;
            }
            return false;
        }

        boolean canSatisfy() {
            if (this.isSatisfied()) {
                return true;
            }
            if (this.what.equals("plugin")) {
                return this.plugin.canBeInstalled();
            }
            return false;
        }

        void satisfy(Roster roster, String installDirectory, boolean downloadSource) {
            if ("plugin".equals(this.what)) {
                String installedVersion = this.plugin.getInstalledVersion();
                for (int i = 0; i < this.plugin.branches.size(); ++i) {
                    Branch branch = this.plugin.branches.get(i);
                    if (installedVersion != null && StandardUtilities.compareStrings(installedVersion, branch.version, false) >= 0 || this.from != null && StandardUtilities.compareStrings(branch.version, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(branch.version, this.to, false) > 0) continue;
                    this.plugin.install(roster, installDirectory, downloadSource, false);
                    return;
                }
            }
        }

        public String toString() {
            return "[what=" + this.what + ",from=" + this.from + ",to=" + this.to + ",plugin=" + String.valueOf(this.plugin) + "]";
        }
    }

    static class PluginSet {
        String name;
        final List<String> plugins = new ArrayList<String>();

        PluginSet() {
        }

        public String toString() {
            return this.plugins.toString();
        }
    }
}

