/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ProgressObserver;
import org.jedit.io.HttpException;

public class RemotePluginList {
    public static final int GZIP_MAGIC_1 = 31;
    public static final int GZIP_MAGIC_2 = 139;
    private final ProgressObserver progressObserver;
    private final String id;

    public RemotePluginList(ProgressObserver progressObserver, String id) {
        this.progressObserver = progressObserver;
        this.id = id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    String getPluginList() throws IOException, URISyntaxException {
        String string;
        this.progressObserver.setStatus(jEdit.getProperty("plugin-manager.list-download"));
        String gzipURL = jEdit.getProperty("plugin-manager.export-url") + "?mirror=" + RemotePluginList.buildMirror(this.id) + "&new_url_scheme";
        long start = System.currentTimeMillis();
        HttpRequest httpRequest = HttpRequest.newBuilder(new URI(gzipURL)).GET().build();
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpResponse<byte[]> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofByteArray());
        if (httpResponse.statusCode() != 200) throw new HttpException(httpResponse.statusCode(), new String(httpResponse.body()));
        InputStream inputStream = RemotePluginList.openPluginListStream(new ByteArrayInputStream(httpResponse.body()));
        try {
            String xml = IOUtilities.toString(inputStream);
            jEdit.setProperty("plugin-manager.mirror.cached-id", this.id);
            Log.log(3, this, "Updated cached pluginlist " + (System.currentTimeMillis() - start));
            string = xml;
            if (inputStream == null) return string;
        }
        catch (Throwable throwable) {
            try {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        inputStream.close();
        return string;
    }

    static InputStream openPluginListStream(InputStream inputStream) throws IOException {
        FilterInputStream in = new BufferedInputStream(inputStream);
        if (((InputStream)in).markSupported()) {
            ((InputStream)in).mark(2);
            int b1 = ((InputStream)in).read();
            int b2 = ((InputStream)in).read();
            ((InputStream)in).reset();
            if (b1 == 31 && b2 == 139) {
                in = new GZIPInputStream(in);
            }
        }
        return in;
    }

    @Nonnull
    private static String buildMirror(String id) {
        return id != null && !"NONE".equals(id) ? id : "default";
    }
}

