/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.print;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gjt.sp.jedit.print.BasicPrintPreviewPaneUI;
import org.gjt.sp.jedit.print.PrintPreviewModel;
import org.gjt.sp.jedit.print.PrintPreviewPaneUI;

public class PrintPreviewPane
extends JComponent {
    private static final String uiClassID = "PrintPreviewPaneUI";
    private PrintPreviewModel printPreviewModel = null;
    private Set<ChangeListener> changeListeners = new HashSet<ChangeListener>();

    public PrintPreviewPane() {
        this.updateUI();
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((PrintPreviewPaneUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicPrintPreviewPaneUI());
        }
        this.fireStateChanged();
    }

    @Override
    public PrintPreviewPaneUI getUI() {
        return (PrintPreviewPaneUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void addChangeListener(ChangeListener cl) {
        if (cl != null) {
            this.changeListeners.add(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        if (cl != null) {
            this.changeListeners.remove(cl);
        }
    }

    public void fireStateChanged() {
        if (this.changeListeners.size() > 0) {
            ChangeEvent event = new ChangeEvent(this);
            for (ChangeListener cl : this.changeListeners) {
                cl.stateChanged(event);
            }
        }
    }

    public void setModel(PrintPreviewModel model) {
        this.printPreviewModel = model;
        this.fireStateChanged();
    }

    public PrintPreviewModel getModel() {
        return this.printPreviewModel;
    }

    public void clear() {
        this.setModel(null);
    }

    public void reset() {
        this.fireStateChanged();
    }
}

