/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.ParserRule;
import org.gjt.sp.util.StandardUtilities;

public class ParserRuleSet {
    private static final ParserRuleSet[] standard = new ParserRuleSet[19];
    private static final int BASE_CACHE = 166;
    private final String modeName;
    private final String setName;
    private Hashtable<String, String> props;
    private KeywordMap keywords;
    private int ruleCount;
    private final List<ParserRule> allRules;
    private List<ParserRule>[] ruleArray;
    private final List<ParserRule> rulesForNull;
    private final List<ParserRuleSet> imports;
    private int terminateChar = -1;
    private boolean ignoreCase = true;
    private byte defaultToken;
    private ParserRule escapeRule;
    private boolean highlightDigits;
    private Pattern digitRE;
    private String _noWordSep;
    private String noWordSep;
    private boolean builtIn;

    public static ParserRuleSet getStandardRuleSet(byte id) {
        return standard[id];
    }

    public ParserRuleSet(String modeName, String setName) {
        this.modeName = modeName;
        this.setName = setName;
        this.allRules = new ArrayList<ParserRule>();
        this.rulesForNull = new ArrayList<ParserRule>();
        this.ruleArray = (List[])StandardUtilities.castUnchecked(Array.newInstance(List.class, 166));
        this.imports = new ArrayList<ParserRuleSet>();
    }

    public String getModeName() {
        return this.modeName;
    }

    public String getSetName() {
        return this.setName;
    }

    public String getName() {
        return this.modeName + "::" + this.setName;
    }

    public Hashtable<String, String> getProperties() {
        return this.props;
    }

    public void setProperties(Hashtable<String, String> props) {
        this.props = props;
        this._noWordSep = null;
    }

    public void resolveImports() {
        for (ParserRuleSet ruleset : this.imports) {
            if (!ruleset.imports.isEmpty()) {
                ruleset.imports.remove(this);
                ruleset.resolveImports();
            }
            ruleset.allRules.forEach(this::addRule);
            if (ruleset.keywords == null) continue;
            if (this.keywords == null) {
                this.keywords = new KeywordMap(this.ignoreCase);
            }
            this.keywords.add(ruleset.keywords);
        }
        this.imports.clear();
    }

    public void addRuleSet(ParserRuleSet ruleset) {
        this.imports.add(ruleset);
    }

    public void addRule(ParserRule parserRule) {
        ++this.ruleCount;
        this.allRules.add(parserRule);
        if (parserRule.upHashChars == null) {
            if (parserRule.upHashChar == null || parserRule.upHashChar.length == 0) {
                this.rulesForNull.add(parserRule);
            } else {
                this.addRule(parserRule.upHashChar[0], parserRule);
                this.addRule(Character.toLowerCase(parserRule.upHashChar[0]), parserRule);
            }
        } else {
            for (char upHashChar : parserRule.upHashChars) {
                this.addRule(upHashChar, parserRule);
                this.addRule(Character.toLowerCase(upHashChar), parserRule);
            }
        }
    }

    private void addRule(char ch, ParserRule parserRule) {
        List<ParserRule> parserRules;
        if (ch >= this.ruleArray.length) {
            this.ruleArray = Arrays.copyOf(this.ruleArray, Math.min(Math.min(this.ruleArray.length * 2, ch + '\u0001'), 131071));
        }
        if ((parserRules = this.ruleArray[ch]) == null) {
            this.ruleArray[ch] = parserRules = new ArrayList<ParserRule>();
        }
        parserRules.add(parserRule);
    }

    @Nonnull
    public List<ParserRule> getRules(char key) {
        List<ParserRule> rulesForKey = null;
        if (key < this.ruleArray.length) {
            rulesForKey = this.ruleArray[key];
        }
        if (this.rulesForNull.isEmpty()) {
            if (rulesForKey == null) {
                return Collections.emptyList();
            }
            return rulesForKey;
        }
        if (rulesForKey == null || rulesForKey.isEmpty()) {
            return this.rulesForNull;
        }
        int size = this.rulesForNull.size() + rulesForKey.size();
        ArrayList<ParserRule> mixed = new ArrayList<ParserRule>(size);
        mixed.addAll(rulesForKey);
        mixed.addAll(this.rulesForNull);
        return mixed;
    }

    public int getRuleCount() {
        return this.ruleCount;
    }

    public int getTerminateChar() {
        return this.terminateChar;
    }

    public void setTerminateChar(int atChar) {
        this.terminateChar = atChar >= 0 ? atChar : -1;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean b) {
        this.ignoreCase = b;
    }

    public KeywordMap getKeywords() {
        return this.keywords;
    }

    public void setKeywords(KeywordMap km) {
        this.keywords = km;
        this._noWordSep = null;
    }

    public boolean getHighlightDigits() {
        return this.highlightDigits;
    }

    public void setHighlightDigits(boolean highlightDigits) {
        this.highlightDigits = highlightDigits;
    }

    public Pattern getDigitRegexp() {
        return this.digitRE;
    }

    public void setDigitRegexp(Pattern digitRE) {
        this.digitRE = digitRE;
    }

    public ParserRule getEscapeRule() {
        return this.escapeRule;
    }

    public void setEscapeRule(ParserRule escapeRule) {
        this.escapeRule = escapeRule;
    }

    public byte getDefault() {
        return this.defaultToken;
    }

    public void setDefault(byte def) {
        this.defaultToken = def;
    }

    public String getNoWordSep() {
        if (this._noWordSep == null) {
            this._noWordSep = this.noWordSep;
            if (this.noWordSep == null) {
                this.noWordSep = "";
            }
            if (this.keywords != null) {
                this.noWordSep = this.noWordSep + this.keywords.getNonAlphaNumericChars();
            }
        }
        return this.noWordSep;
    }

    public void setNoWordSep(String noWordSep) {
        this.noWordSep = noWordSep;
        this._noWordSep = null;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.modeName + "::" + this.setName + "]";
    }

    static {
        for (byte i = 0; i < 19; i = (byte)(i + 1)) {
            ParserRuleSet.standard[i] = new ParserRuleSet(null, null);
            standard[i].setDefault(i);
            ParserRuleSet.standard[i].builtIn = true;
        }
    }
}

