/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.util.ArrayList;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.buffer.BufferAdapter;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.ColumnBlock;
import org.gjt.sp.jedit.textarea.Node;
import org.gjt.sp.jedit.textarea.TextArea;

public class ElasticTabStopBufferListener
extends BufferAdapter {
    private final TextArea textArea;
    private boolean handledInsertion = true;
    private boolean handledDeletion = true;
    private boolean singleTabDeleted;

    public ElasticTabStopBufferListener(TextArea textArea) {
        this.textArea = textArea;
    }

    private void fullyUpdateColumnBlocks(JEditBuffer buffer) {
        buffer.indentUsingElasticTabstops();
        this.handledInsertion = true;
        this.handledDeletion = true;
        buffer.getColumnBlock().setDirtyStatus(false);
        this.textArea.chunkCache.invalidateChunksFromPhys(0);
        this.textArea.invalidateLineRange(0, buffer.getLineCount() - 1);
    }

    @Override
    public void contentInserted(JEditBuffer buffer, int startLine, int offset, int numLines, int length) {
        int indexofBlockAbove;
        ColumnBlock rootBlock;
        if (!buffer.isElasticTabstopsOn()) {
            return;
        }
        boolean isASimpleChar = false;
        boolean singleTabInserted = false;
        if (numLines == 0 && length == 1) {
            isASimpleChar = true;
            String charDeleted = buffer.getText(offset, length);
            if (charDeleted.equals("\t")) {
                singleTabInserted = true;
            }
        }
        if ((rootBlock = buffer.getColumnBlock()) == null) {
            return;
        }
        ColumnBlock block = rootBlock.searchChildren(startLine);
        ColumnBlock blockjustAbove = null;
        boolean liesWithinBlock = false;
        int startIndex = -1;
        if (block != null) {
            startIndex = rootBlock.getChildren().indexOf(block);
            indexofBlockAbove = startIndex - 1;
            if (block.isLineWithinThisBlock(startLine) == 0) {
                ++startIndex;
                liesWithinBlock = true;
            }
        } else {
            startIndex = rootBlock.getChildren().size();
            indexofBlockAbove = startIndex - 1;
        }
        if (indexofBlockAbove >= 0 && ((ColumnBlock)rootBlock.getChildren().get((int)indexofBlockAbove)).endLine + 1 == startLine) {
            blockjustAbove = (ColumnBlock)rootBlock.getChildren().get(indexofBlockAbove);
        }
        if (numLines > 0) {
            rootBlock.endLine += numLines;
            for (int i = startIndex; i < rootBlock.getChildren().size(); ++i) {
                ((ColumnBlock)rootBlock.getChildren().get(i)).updateLineNo(numLines);
            }
        }
        int startingLine = -1;
        int endLine = -1;
        if (liesWithinBlock) {
            ColumnBlock innerContainingBlock = block.getContainingBlock(startLine, offset);
            if (isASimpleChar && (innerContainingBlock != null || !singleTabInserted)) {
                if (innerContainingBlock != null) {
                    if (!singleTabInserted) {
                        innerContainingBlock.updateColumnBlockLineOffset(startLine, length, false);
                        startingLine = innerContainingBlock.startLine;
                        innerContainingBlock.setTabSizeDirtyStatus(true, false);
                        endLine = innerContainingBlock.endLine;
                    } else {
                        ColumnBlock innerParent = (ColumnBlock)innerContainingBlock.getParent();
                        startingLine = innerParent.startLine;
                        endLine = innerParent.endLine;
                        innerParent.getChildren().removeAllElements();
                        buffer.updateColumnBlocks(startingLine, endLine, (int)innerParent.columnBlockWidth, innerParent);
                    }
                } else {
                    startingLine = startLine;
                    endLine = startLine;
                }
            }
            if (!isASimpleChar || innerContainingBlock == null && singleTabInserted) {
                startingLine = block.getStartLine();
                endLine = block.getEndLine() + numLines;
                rootBlock.getChildren().remove(block);
                buffer.updateColumnBlocks(startingLine, endLine, 0, rootBlock);
            }
        } else {
            Segment seg = new Segment();
            buffer.getText(offset, length, seg);
            if (buffer.getTabStopPosition(seg) >= 0) {
                if (blockjustAbove != null) {
                    rootBlock.getChildren().remove(blockjustAbove);
                    startingLine = blockjustAbove.startLine;
                } else {
                    startingLine = startLine;
                }
                if (block != null && block.startLine == startLine + numLines + 1) {
                    rootBlock.getChildren().remove(block);
                    endLine = block.endLine;
                } else {
                    endLine = startLine + numLines;
                }
                buffer.updateColumnBlocks(startingLine, endLine, 0, rootBlock);
            }
        }
        this.handledInsertion = true;
        rootBlock.setDirtyStatus(false);
        if (startingLine != -1 && endLine != -1 && this.handledDeletion) {
            this.textArea.chunkCache.invalidateChunksFromPhys(startingLine);
            this.textArea.invalidateLineRange(startingLine, endLine);
        }
    }

    @Override
    public void contentRemoved(JEditBuffer buffer, int startLine, int offset, int numLines, int length) {
        if (!buffer.isElasticTabstopsOn()) {
            return;
        }
        boolean isASimpleChar = false;
        ColumnBlock rootBlock = buffer.getColumnBlock();
        if (rootBlock == null) {
            return;
        }
        if (numLines == 0 && length == 1) {
            isASimpleChar = true;
        }
        if (!isASimpleChar) {
            ColumnBlock firstBlockEffected = rootBlock.searchChildren(startLine);
            int startLineToBuild = -1;
            int endLineToBuild = -1;
            ColumnBlock firstBlockToBeUpdated = null;
            ColumnBlock firstBlockToBeRemoved = null;
            ColumnBlock lastBlockToBeRemoved = null;
            if (firstBlockEffected != null) {
                boolean lastLineLiesBelow;
                int posFirstLine;
                int indexFirstBlockEffected = rootBlock.getChildren().indexOf(firstBlockEffected);
                ColumnBlock blockAboveFirstEffected = null;
                boolean justBelowBlock = false;
                if (indexFirstBlockEffected > 0) {
                    blockAboveFirstEffected = (ColumnBlock)rootBlock.getChildren().get(indexFirstBlockEffected - 1);
                    if (blockAboveFirstEffected.endLine == startLine - 1) {
                        justBelowBlock = true;
                    }
                }
                boolean firstLineLiesInside = (posFirstLine = firstBlockEffected.isLineWithinThisBlock(startLine)) == 0;
                boolean firstLineLiesAbove = posFirstLine < 0;
                int posLastLine = firstBlockEffected.isLineWithinThisBlock(startLine + numLines);
                boolean lastLineLiesInside = posLastLine == 0;
                boolean lastLineLiesAbove = posLastLine < 0;
                boolean bl = lastLineLiesBelow = posLastLine > 0;
                if (lastLineLiesAbove) {
                    firstBlockToBeUpdated = firstBlockEffected;
                    lastBlockToBeRemoved = null;
                    firstBlockToBeRemoved = null;
                    endLineToBuild = -1;
                    startLineToBuild = -1;
                } else if ((firstLineLiesInside || firstLineLiesAbove) && lastLineLiesInside) {
                    startLineToBuild = Math.min(firstBlockEffected.startLine, startLine);
                    endLineToBuild = firstBlockEffected.endLine - numLines;
                    firstBlockToBeRemoved = lastBlockToBeRemoved = firstBlockEffected;
                    if (justBelowBlock) {
                        startLineToBuild = blockAboveFirstEffected.startLine;
                        firstBlockToBeRemoved = blockAboveFirstEffected;
                    }
                } else if (firstLineLiesInside || firstLineLiesAbove) {
                    startLineToBuild = Math.min(startLine, firstBlockEffected.startLine);
                    firstBlockToBeRemoved = firstBlockEffected;
                    ColumnBlock blockBelow = rootBlock.searchChildren(startLine + numLines);
                    int indexLastBlock = rootBlock.getChildren().indexOf(blockBelow);
                    if (blockBelow != null) {
                        if (blockBelow.isLineWithinThisBlock(startLine + numLines) == 0) {
                            if (justBelowBlock) {
                                startLineToBuild = blockAboveFirstEffected.startLine;
                                firstBlockToBeRemoved = blockAboveFirstEffected;
                            }
                            lastBlockToBeRemoved = blockBelow;
                            endLineToBuild = blockBelow.endLine - numLines;
                        } else {
                            lastBlockToBeRemoved = (ColumnBlock)rootBlock.getChildren().get(indexLastBlock - 1);
                            int n = endLineToBuild = firstLineLiesAbove ? -1 : startLine;
                            if (blockBelow.startLine == startLine + numLines + 1 && endLineToBuild != -1) {
                                endLineToBuild = blockBelow.endLine - numLines;
                                lastBlockToBeRemoved = blockBelow;
                            }
                            if (endLineToBuild == -1) {
                                startLineToBuild = -1;
                            }
                        }
                    } else {
                        lastBlockToBeRemoved = (ColumnBlock)rootBlock.getChildren().get(rootBlock.getChildren().size() - 1);
                        if (firstLineLiesInside) {
                            endLineToBuild = startLine;
                        } else {
                            startLineToBuild = -1;
                            endLineToBuild = -1;
                        }
                    }
                }
            } else {
                startLineToBuild = -1;
                endLineToBuild = -1;
                firstBlockToBeRemoved = null;
                lastBlockToBeRemoved = null;
            }
            ArrayList<Node> blocksToBeRemoved = null;
            if (firstBlockToBeRemoved != null) {
                int startIndex = rootBlock.getChildren().indexOf(firstBlockToBeRemoved);
                blocksToBeRemoved = new ArrayList<Node>();
                if (lastBlockToBeRemoved == null) {
                    throw new IllegalArgumentException("Deletion not handled properly");
                }
                int endIndex = rootBlock.getChildren().indexOf(lastBlockToBeRemoved);
                for (int i = startIndex; i <= endIndex; ++i) {
                    blocksToBeRemoved.add(rootBlock.getChildren().get(i));
                }
            }
            if (numLines > 0) {
                rootBlock.endLine -= numLines;
                if (lastBlockToBeRemoved != null || firstBlockToBeUpdated != null) {
                    int startIndex;
                    if (lastBlockToBeRemoved != null) {
                        startIndex = rootBlock.getChildren().indexOf(lastBlockToBeRemoved);
                        ++startIndex;
                    } else {
                        startIndex = rootBlock.getChildren().indexOf(firstBlockToBeUpdated);
                    }
                    for (int i = startIndex; i < rootBlock.getChildren().size(); ++i) {
                        ((ColumnBlock)rootBlock.getChildren().get(i)).updateLineNo(-1 * numLines);
                    }
                }
            }
            if (blocksToBeRemoved != null) {
                rootBlock.getChildren().removeAll(blocksToBeRemoved);
            }
            if (startLineToBuild != -1 && endLineToBuild != -1) {
                buffer.updateColumnBlocks(startLineToBuild, endLineToBuild, 0, rootBlock);
                rootBlock.setDirtyStatus(false);
                this.textArea.chunkCache.invalidateChunksFromPhys(startLineToBuild);
                this.textArea.invalidateLineRange(startLineToBuild, endLineToBuild);
            }
            rootBlock.setDirtyStatus(false);
            this.handledDeletion = true;
        } else {
            int endLine;
            int startingLine;
            ColumnBlock innerContainingBlock = rootBlock.getContainingBlock(startLine, offset);
            if (innerContainingBlock != null) {
                if (!this.singleTabDeleted) {
                    innerContainingBlock.updateColumnBlockLineOffset(startLine, -1 * length, false);
                    startingLine = innerContainingBlock.startLine;
                    endLine = innerContainingBlock.endLine;
                    innerContainingBlock.setTabSizeDirtyStatus(true, false);
                } else {
                    ColumnBlock innerParent = (ColumnBlock)innerContainingBlock.getParent();
                    startingLine = innerContainingBlock.startLine;
                    endLine = innerContainingBlock.endLine;
                    innerParent.getChildren().remove(innerContainingBlock);
                    buffer.updateColumnBlocks(startingLine, endLine, (int)innerParent.columnBlockWidth, innerParent);
                }
            } else {
                startingLine = startLine;
                endLine = startLine;
            }
            this.handledDeletion = true;
            rootBlock.setDirtyStatus(false);
            if (startingLine != -1 && endLine != -1) {
                this.textArea.chunkCache.invalidateChunksFromPhys(startingLine);
                this.textArea.invalidateLineRange(startingLine, endLine);
            }
        }
    }

    @Override
    public void transactionComplete(JEditBuffer buffer) {
        if (!buffer.getBooleanProperty("elasticTabstops")) {
            return;
        }
        if (!(!buffer.getBooleanProperty("elasticTabstops") || this.handledInsertion && this.handledDeletion)) {
            this.fullyUpdateColumnBlocks(buffer);
        }
    }

    @Override
    public void preContentInserted(JEditBuffer buffer, int startLine, int offset, int numLines, int length) {
        if (!buffer.isElasticTabstopsOn()) {
            return;
        }
        this.handledInsertion = false;
        if (buffer.getColumnBlock() != null) {
            buffer.getColumnBlock().setDirtyStatus(true);
        }
    }

    @Override
    public void preContentRemoved(JEditBuffer buffer, int startLine, int offset, int numLines, int length) {
        if (!buffer.isElasticTabstopsOn()) {
            return;
        }
        this.handledDeletion = false;
        this.singleTabDeleted = false;
        if (buffer.getColumnBlock() != null) {
            String str;
            buffer.getColumnBlock().setDirtyStatus(true);
            if (numLines == 0 && length == 1 && (str = buffer.getText(offset, length)).equals("\t")) {
                this.singleTabDeleted = true;
            }
        }
    }
}

