/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import org.gjt.sp.jedit.Debug;
import org.gjt.sp.util.Log;

class RangeMap {
    private int[] fvm;
    private int fvmcount;
    private int lastfvmget;

    RangeMap() {
        this.fvm = new int[2];
        this.lastfvmget = -1;
    }

    RangeMap(RangeMap copy) {
        this.fvm = (int[])copy.fvm.clone();
        this.fvmcount = copy.fvmcount;
    }

    void reset(int lines) {
        this.lastfvmget = -1;
        this.fvmcount = 2;
        this.fvm[0] = 0;
        this.fvm[1] = lines;
    }

    int first() {
        return this.fvm[0];
    }

    int last() {
        return this.fvm[this.fvmcount - 1] - 1;
    }

    int lookup(int index) {
        return this.fvm[index];
    }

    int search(int line) {
        if (line < this.fvm[0]) {
            return -1;
        }
        if (line >= this.fvm[this.fvmcount - 1]) {
            return this.fvmcount - 1;
        }
        if (this.lastfvmget != -1 && line >= this.fvm[this.lastfvmget] && (this.lastfvmget == this.fvmcount - 1 || line < this.fvm[this.lastfvmget + 1])) {
            return this.lastfvmget;
        }
        int start = 0;
        int end = this.fvmcount - 1;
        block4: while (true) {
            switch (end - start) {
                case 0: {
                    this.lastfvmget = start;
                    break block4;
                }
                case 1: {
                    int value = this.fvm[end];
                    if (value <= line) {
                        this.lastfvmget = end;
                        break block4;
                    }
                    this.lastfvmget = start;
                    break block4;
                }
                default: {
                    int pivot = (end + start) / 2;
                    int value = this.fvm[pivot];
                    if (value == line) {
                        this.lastfvmget = pivot;
                        break block4;
                    }
                    if (value < line) {
                        start = pivot;
                        continue block4;
                    }
                    end = pivot - 1;
                    continue block4;
                }
            }
            break;
        }
        return this.lastfvmget;
    }

    void put(int start, int end, int[] put) {
        int putl;
        int delta;
        if (Debug.FOLD_VIS_DEBUG) {
            StringBuilder buf = new StringBuilder(50);
            buf.append("fvmput(").append(start).append(',');
            buf.append(end).append(',');
            buf.append('{');
            if (put != null) {
                for (int i = 0; i < put.length; ++i) {
                    if (i != 0) {
                        buf.append(',');
                    }
                    buf.append(put[i]);
                }
            }
            buf.append("})");
            Log.log(1, this, buf.toString());
        }
        if (this.fvmcount + (delta = (putl = put == null ? 0 : put.length) - (end - start)) > this.fvm.length) {
            int[] newfvm = new int[(this.fvm.length << 1) + 1];
            System.arraycopy(this.fvm, 0, newfvm, 0, this.fvmcount);
            this.fvm = newfvm;
        }
        if (delta != 0) {
            System.arraycopy(this.fvm, end, this.fvm, start + putl, this.fvmcount - end);
        }
        if (putl != 0) {
            System.arraycopy(put, 0, this.fvm, start, put.length);
        }
        this.fvmcount += delta;
        this.dump();
        if (this.fvmcount == 0) {
            throw new InternalError();
        }
    }

    void put2(int starti, int endi, int start, int end) {
        if (Debug.FOLD_VIS_DEBUG) {
            Log.log(1, this, "*fvmput2(" + starti + "," + endi + "," + start + "," + end + ")");
        }
        if (starti != -1 && this.fvm[starti] == start) {
            if (endi <= this.fvmcount - 2 && this.fvm[endi + 1] == end + 1) {
                this.put(starti, endi + 2, null);
            } else {
                this.put(starti, endi + 1, new int[]{end + 1});
            }
        } else if (endi != this.fvmcount - 1 && this.fvm[endi + 1] == end + 1) {
            this.put(starti + 1, endi + 2, new int[]{start});
        } else {
            this.put(starti + 1, endi + 1, new int[]{start, end + 1});
        }
    }

    int next(int line) {
        int index = this.search(line);
        if (index % 2 != 0) {
            if (this.fvmcount == index + 1) {
                return -1;
            }
            return this.fvm[index + 1];
        }
        if (line == this.fvm[index + 1] - 1) {
            if (this.fvmcount == index + 2) {
                return -1;
            }
            return this.fvm[index + 2];
        }
        return line + 1;
    }

    int prev(int line) {
        int index = this.search(line);
        if (index == -1) {
            return -1;
        }
        if (index % 2 == 1) {
            return this.fvm[index] - 1;
        }
        if (line == this.fvm[index]) {
            if (index == 0) {
                return -1;
            }
            return this.fvm[index - 1] - 1;
        }
        return line - 1;
    }

    void show(int start, int end) {
        int starti = this.search(start);
        int endi = this.search(end);
        if (starti % 2 == 0) {
            if (endi % 2 == 0) {
                this.put(starti + 1, endi + 1, null);
            } else if (endi != this.fvmcount - 1 && this.fvm[endi + 1] == end + 1) {
                this.put(starti + 1, endi + 2, null);
            } else {
                this.put(starti + 1, endi, null);
                this.fvm[starti + 1] = end + 1;
            }
        } else if (endi % 2 == 0) {
            if (starti != -1 && this.fvm[starti] == start) {
                this.put(starti, endi + 1, null);
            } else {
                this.put(starti + 1, endi, null);
                this.fvm[starti + 1] = start;
            }
        } else {
            this.put2(starti, endi, start, end);
        }
        this.lastfvmget = -1;
    }

    void hide(int start, int end) {
        int starti = this.search(start);
        int endi = this.search(end);
        if (starti % 2 == 0) {
            if (endi % 2 == 0) {
                this.put2(starti, endi, start, end);
            } else if (start == this.fvm[0]) {
                this.put(starti, endi + 1, null);
            } else {
                this.put(starti + 1, endi, null);
                this.fvm[starti + 1] = start;
            }
        } else if (endi % 2 == 0) {
            if (end + 1 == this.fvm[this.fvmcount - 1]) {
                this.put(starti + 1, endi + 2, null);
            } else {
                this.put(starti + 1, endi, null);
                this.fvm[starti + 1] = end + 1;
            }
        } else {
            this.put(starti + 1, endi + 1, null);
        }
        this.lastfvmget = -1;
    }

    int count() {
        return this.fvmcount;
    }

    void dump() {
        if (Debug.FOLD_VIS_DEBUG) {
            StringBuilder buf = new StringBuilder("{");
            for (int i = 0; i < this.fvmcount; ++i) {
                if (i != 0) {
                    buf.append(',');
                }
                buf.append(this.fvm[i]);
            }
            buf.append('}');
            Log.log(1, this, "fvm = " + String.valueOf(buf));
        }
    }

    void contentInserted(int startLine, int numLines) {
        if (numLines != 0) {
            int start;
            int index = this.search(startLine);
            int i = start = index + 1;
            while (i < this.fvmcount) {
                int n = i++;
                this.fvm[n] = this.fvm[n] + numLines;
            }
            this.lastfvmget = -1;
            this.dump();
        }
    }

    boolean preContentRemoved(int startLine, int numLines) {
        boolean returnValue = false;
        int endLine = startLine + numLines;
        int starti = this.search(startLine);
        int endi = this.search(endLine);
        if (Math.abs(starti % 2) == Math.abs(endi % 2)) {
            if (endi - starti == this.fvmcount) {
                returnValue = true;
                starti = 1;
            } else {
                this.put(starti + 1, endi + 1, null);
                ++starti;
            }
        } else if (starti != -1 && this.fvm[starti] == startLine) {
            if (endi - starti == this.fvmcount - 1) {
                returnValue = true;
                starti = 1;
            } else {
                this.put(starti, endi + 1, null);
            }
        } else {
            this.put(starti + 1, endi, null);
            this.fvm[starti + 1] = startLine;
            starti += 2;
        }
        int i = starti;
        while (i < this.fvmcount) {
            int n = i++;
            this.fvm[n] = this.fvm[n] - numLines;
        }
        this.lastfvmget = -1;
        this.dump();
        return returnValue;
    }
}

