/*
 * Decompiled with CFR 0.152.
 */
package org.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.TextListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.OptionGroup;
import org.gjt.sp.jedit.OptionPane;
import org.gjt.sp.jedit.gui.OptionsDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StringModel;
import org.jedit.options.OptionTreeModel;

public class OptionGroupPane
extends AbstractOptionPane
implements TreeSelectionListener {
    OptionGroup optionGroup;
    JSplitPane splitter;
    JTree paneTree;
    OptionPane currentPane;
    OptionTreeModel optionTreeModel;
    Map<Object, OptionPane> deferredOptionPanes;
    JPanel stage;
    StringModel title = new StringModel();

    public OptionGroupPane(OptionGroup group) {
        super(group.getName());
        this.optionGroup = group;
        this.init();
    }

    void addTextListener(TextListener l) {
        this.title.addTextListener(l);
    }

    public String getTitle() {
        return this.title.toString();
    }

    void setTitle(String newTitle) {
        this.title.setText(newTitle);
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        int i;
        TreePath path = evt.getPath();
        if (path == null) {
            return;
        }
        Object lastPathComponent = path.getLastPathComponent();
        if (!(lastPathComponent instanceof String) && !(lastPathComponent instanceof OptionPane)) {
            return;
        }
        Object[] nodes = path.getPath();
        StringBuilder sb = new StringBuilder();
        OptionPane optionPane = null;
        int lastIdx = nodes.length - 1;
        int n = i = this.paneTree.isRootVisible() ? 0 : 1;
        while (i <= lastIdx) {
            block12: {
                String label;
                block10: {
                    String propName;
                    block13: {
                        Object node;
                        block11: {
                            block9: {
                                node = nodes[i];
                                if (!(node instanceof OptionPane)) break block9;
                                optionPane = (OptionPane)node;
                                label = jEdit.getProperty("options." + optionPane.getName() + ".label");
                                break block10;
                            }
                            if (!(node instanceof OptionGroup)) break block11;
                            label = ((OptionGroup)node).getLabel();
                            break block10;
                        }
                        if (!(node instanceof String)) break block12;
                        label = jEdit.getProperty("options." + String.valueOf(node) + ".label");
                        optionPane = this.deferredOptionPanes.get((String)node);
                        if (optionPane != null) break block10;
                        propName = "options." + String.valueOf(node) + ".code";
                        String code = jEdit.getProperty(propName);
                        if (code == null) break block13;
                        optionPane = (OptionPane)BeanShell.eval(jEdit.getActiveView(), BeanShell.getNameSpace(), code);
                        if (optionPane == null) break block12;
                        this.deferredOptionPanes.clear();
                        this.deferredOptionPanes.put(node, optionPane);
                        break block10;
                    }
                    Log.log(9, this, propName + " not defined");
                    break block12;
                }
                if (label != null) {
                    sb.append(label);
                }
                if (i > 0 && i < lastIdx) {
                    sb.append(": ");
                }
            }
            ++i;
        }
        if (optionPane == null) {
            return;
        }
        String ttext = jEdit.getProperty("optional.title-template", new Object[]{this.optionGroup.getName(), sb.toString()});
        this.setTitle(ttext);
        try {
            optionPane.init();
        }
        catch (Throwable t) {
            Log.log(9, this, "Error initializing option pane:");
            Log.log(9, this, t);
        }
        if (this.currentPane != null) {
            this.stage.remove(this.currentPane.getComponent());
        }
        this.currentPane = optionPane;
        this.stage.add("Center", this.currentPane.getComponent());
        this.stage.revalidate();
        this.stage.repaint();
        this.currentPane = optionPane;
    }

    private boolean selectPane(OptionGroup node, String name) {
        return this.selectPane(node, name, new ArrayList<Object>());
    }

    private boolean selectPane(OptionGroup node, String name, ArrayList<Object> path) {
        path.add(node);
        Enumeration<Object> e = node.getMembers();
        while (e.hasMoreElements()) {
            Object pane;
            Object obj = e.nextElement();
            if (obj instanceof OptionGroup) {
                OptionGroup grp = (OptionGroup)obj;
                if (grp.getName().equals(name)) {
                    path.add(grp);
                    path.add(grp.getMember(0));
                    TreePath treePath = new TreePath(path.toArray());
                    this.paneTree.scrollPathToVisible(treePath);
                    this.paneTree.setSelectionPath(treePath);
                    return true;
                }
                if (!this.selectPane((OptionGroup)obj, name, path)) continue;
                return true;
            }
            if (obj instanceof OptionPane) {
                pane = (OptionPane)obj;
                if (!pane.getName().equals(name) && name != null) continue;
                path.add(pane);
                TreePath treePath = new TreePath(path.toArray());
                this.paneTree.scrollPathToVisible(treePath);
                this.paneTree.setSelectionPath(treePath);
                return true;
            }
            if (!(obj instanceof String) || !((String)(pane = (String)obj)).equals(name) && name != null) continue;
            path.add(pane);
            TreePath treePath = new TreePath(path.toArray());
            this.paneTree.scrollPathToVisible(treePath);
            try {
                this.paneTree.setSelectionPath(treePath);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return true;
        }
        path.remove(node);
        return false;
    }

    @Override
    protected void _init() {
        this.setLayout(new BorderLayout());
        this.deferredOptionPanes = new HashMap<Object, OptionPane>();
        this.optionTreeModel = new OptionTreeModel();
        OptionGroup rootGroup = (OptionGroup)this.optionTreeModel.getRoot();
        Enumeration<Object> members = this.optionGroup.getMembers();
        while (members.hasMoreElements()) {
            Object member = members.nextElement();
            if (member instanceof OptionGroup) {
                rootGroup.addOptionGroup((OptionGroup)member);
                continue;
            }
            if (!(member instanceof String)) continue;
            rootGroup.addOptionPane((String)member);
        }
        this.paneTree = new JTree(this.optionTreeModel);
        this.paneTree.setRowHeight(0);
        this.paneTree.setRootVisible(false);
        this.paneTree.setCellRenderer(new OptionsDialog.PaneNameRenderer());
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.add((Component)content, "Center");
        this.stage = new JPanel(new BorderLayout());
        if (!OperatingSystem.isMacOSLF()) {
            this.paneTree.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.paneTree.setShowsRootHandles(true);
        this.paneTree.setRootVisible(false);
        JScrollPane scroller = new JScrollPane(this.paneTree, 22, 30);
        scroller.setMinimumSize(new Dimension(120, 0));
        JScrollPane scroll = new JScrollPane(this.stage);
        scroll.getVerticalScrollBar().setUnitIncrement(10);
        this.splitter = new JSplitPane(1, scroller, scroll);
        content.add((Component)this.splitter, "Center");
        this.paneTree.getSelectionModel().addTreeSelectionListener(this);
        OptionGroup rootNode = (OptionGroup)this.paneTree.getModel().getRoot();
        String name = this.optionGroup.getName();
        String pane = jEdit.getProperty(name + ".last");
        this.selectPane(rootNode, pane);
        this.paneTree.setVisibleRowCount(1);
        int dividerLocation = jEdit.getIntegerProperty(name + ".splitter", -1);
        if (dividerLocation != -1) {
            this.splitter.setDividerLocation(dividerLocation);
        } else {
            this.splitter.setDividerLocation(this.paneTree.getPreferredSize().width + scroller.getVerticalScrollBar().getPreferredSize().width);
        }
    }

    @Override
    protected void _save() {
        if (this.currentPane != null) {
            jEdit.setProperty(this.getName() + ".last", this.currentPane.getName());
        }
        int dividerPosition = this.splitter.getDividerLocation();
        jEdit.setIntegerProperty(this.optionGroup.getName() + ".splitter", dividerPosition);
        this.save(this.optionGroup);
    }

    private void save(Object obj) {
        if (obj instanceof OptionGroup) {
            OptionGroup grp = (OptionGroup)obj;
            Enumeration<Object> members = grp.getMembers();
            while (members.hasMoreElements()) {
                this.save(members.nextElement());
            }
        } else if (obj instanceof OptionPane) {
            try {
                ((OptionPane)obj).save();
            }
            catch (Throwable t) {
                Log.log(9, this, "Error saving options:");
                Log.log(9, this, t);
            }
        } else if (obj instanceof String) {
            this.save(this.deferredOptionPanes.get(obj));
        }
    }
}

