/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.Console;
import console.ConsolePane;
import console.ConsolePlugin;
import console.DirectoryStack;
import console.ErrorListModel;
import console.ErrorMatcher;
import console.Output;
import errorlist.DefaultErrorSource;
import errorlist.ErrorSource;
import java.awt.Color;
import org.gjt.sp.jedit.View;

public class CommandOutputParser {
    DirectoryStack directoryStack = new DirectoryStack();
    Output output;
    protected DefaultErrorSource.DefaultError lastError = null;
    View view;
    DefaultErrorSource errorSource;
    ErrorListModel errorMatchers = ErrorListModel.load();
    ErrorMatcher lastMatcher;
    protected Console console;
    Color defaultColor;
    Color color;
    static final int DEFAULT = -1;

    public CommandOutputParser(View v, DefaultErrorSource es, Color defaultColor) {
        this.console = ConsolePlugin.getConsole(v);
        this.output = this.console.getOutput();
        this.defaultColor = defaultColor;
        this.color = defaultColor;
        this.lastMatcher = null;
        this.view = v;
        this.errorSource = es;
    }

    public final int processLine(String text) {
        return this.processLine(text, false);
    }

    public int processLine(String text, boolean disp) {
        int retval = -1;
        if (text == null) {
            return -1;
        }
        if (this.errorMatchers.m_matchers.size() == 0) {
            return -1;
        }
        if (this.directoryStack.processLine(text)) {
            if (disp) {
                this.display(this.color, text);
            }
            return 1;
        }
        String directory = this.directoryStack.current();
        if (this.lastError != null) {
            String message = null;
            if (this.lastMatcher != null && this.lastMatcher.match(this.view, text, directory, (ErrorSource)this.errorSource) == null) {
                message = this.lastMatcher.matchExtra(text);
            }
            if (message != null) {
                this.lastError.addExtraMessage(message);
                return this.lastError.getErrorType();
            }
            if (this.errorSource.getErrorCount() == 0) {
                ErrorSource.registerErrorSource((ErrorSource)this.errorSource);
            }
            this.errorSource.addError(this.lastError);
            this.lastMatcher = null;
            this.lastError = null;
        }
        this.color = this.defaultColor;
        for (ErrorMatcher m : this.errorMatchers.m_matchers) {
            DefaultErrorSource.DefaultError error = m.match(this.view, text, directory, (ErrorSource)this.errorSource);
            if (error == null) continue;
            this.lastError = error;
            this.lastMatcher = m;
            retval = this.lastError.getErrorType();
            if (retval == 0) {
                this.color = this.console.getErrorColor();
                break;
            }
            if (retval != 1) break;
            this.color = this.console.getWarningColor();
            break;
        }
        if (disp) {
            this.display(text);
        }
        return retval;
    }

    public Color getColor() {
        return this.color;
    }

    public void setDirectory(String currentDirectory) {
        this.directoryStack.push(currentDirectory);
    }

    protected void display(Color c, String text) {
        if (text == null) {
            return;
        }
        this.output.writeAttrs(ConsolePane.colorAttributes(c), text + "\n");
    }

    protected void display(String text) {
        if (text == null) {
            return;
        }
        this.output.writeAttrs(ConsolePane.colorAttributes(this.color), text + "\n");
    }

    public void finishErrorParsing() {
        if (this.lastError != null) {
            this.errorSource.addError(this.lastError);
            this.lastError = null;
            this.lastMatcher = null;
        }
    }
}

