/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.Console;
import console.ConsolePane;
import console.Output;
import console.Shell;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.jEdit;

public class ConsoleBeanShell
extends Shell {
    public ConsoleBeanShell() {
        super("BeanShell");
    }

    @Override
    public void printInfoMessage(Output output) {
        if (jEdit.getBooleanProperty((String)"console.shell.info.toggle")) {
            output.print(null, jEdit.getProperty((String)"console.beanshell.info"));
        }
    }

    @Override
    public void printPrompt(Console console, Output output) {
        output.writeAttrs(ConsolePane.colorAttributes(console.getInfoColor()), jEdit.getProperty((String)"console.beanshell.prompt"));
        output.writeAttrs(null, " ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Console console, String input, Output output, Output error, String command) {
        if (error == null) {
            error = output;
        }
        View view = console.getView();
        NameSpace ns = BeanShell.getNameSpace();
        try {
            ns.setVariable("console", (Object)console);
            ns.setVariable("output", (Object)output);
            Object retVal = BeanShell._eval((View)view, (NameSpace)ns, (String)command);
            if (retVal != null) {
                ns.setVariable("retVal", retVal);
                BeanShell._eval((View)view, (NameSpace)ns, (String)"print(retVal);");
                ns.setVariable("retVal", null);
            }
        }
        catch (Exception e) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            error.print(console.getErrorColor(), s.toString());
        }
        finally {
            try {
                ns.setVariable("console", null);
                ns.setVariable("output", null);
            }
            catch (UtilEvalError e) {}
        }
        if (error != output) {
            error.commandDone();
        }
        output.commandDone();
    }

    @Override
    public void stop(Console console) {
    }

    @Override
    public boolean waitFor(Console console) {
        return true;
    }
}

