/*
 * Decompiled with CFR 0.152.
 */
package console.options;

import common.gui.FileTextField;
import console.Console;
import console.Shell;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.jEdit;
import projectviewer.gui.OptionPaneBase;
import projectviewer.vpt.VPTProject;

public class ProjectCommandOptionPane
extends OptionPaneBase
implements ActionListener {
    private VPTProject proj;
    private JComboBox<String> shell;
    private String _shell;
    private HistoryTextField compile;
    private HistoryTextField run;
    private JCheckBox useRunDir;
    private FileTextField runDir;
    private String _runDir;

    public ProjectCommandOptionPane(VPTProject proj) {
        super("pv.commands", "console");
        this.proj = proj;
    }

    protected void _init() {
        String _run;
        this.compile = new HistoryTextField("console.compile.project");
        this.run = new HistoryTextField("console.run.project");
        this.useRunDir = new JCheckBox(jEdit.getProperty((String)"options.pv.useRunDir"));
        this.runDir = new FileTextField();
        this.shell = new JComboBox<String>(Shell.getShellNames());
        this.runDir.setFileSelectionMode(1);
        this.shell.setToolTipText(jEdit.getProperty((String)"options.pv.shell.tooltip"));
        this._runDir = this.proj.getProperty("console.runDir");
        this.useRunDir.setSelected(this._runDir != null);
        this.useRunDir.addActionListener(this);
        if (this._runDir == null) {
            this._runDir = this.proj.getRootPath();
        }
        this.runDir.getTextField().setText(this._runDir);
        this._shell = this.proj.getProperty("console.shell");
        if (this._shell != null && Shell.getShell(this._shell) == null) {
            this._shell = null;
        }
        if (this._shell == null) {
            this._shell = Console.shellForVFS(this.proj.getRootPath());
        }
        this.shell.setSelectedItem(this._shell);
        String _compile = this.proj.getProperty("console.compile");
        if (_compile != null) {
            this.compile.setText(_compile);
        }
        if ((_run = this.proj.getProperty("console.run")) != null) {
            this.run.setText(_run);
        }
        this.addComponent(new JLabel(jEdit.getProperty((String)"options.pv.commands.help")));
        this.addComponent(jEdit.getProperty((String)"options.pv.commands.compile"), (Component)this.compile);
        this.addComponent(jEdit.getProperty((String)"options.pv.commands.run"), (Component)this.run);
        this.addComponent(this.useRunDir, (Component)this.runDir);
        this.addComponent(jEdit.getProperty((String)"options.pv.shell"), this.shell);
        this.actionPerformed(null);
    }

    protected void _save() {
        String ccmd = this.compile.getText();
        if (!ccmd.equals("")) {
            this.proj.setProperty("console.compile", ccmd);
            this.compile.getModel().addItem(ccmd);
        } else {
            this.proj.removeProperty("console.compile");
        }
        String rcmd = this.run.getText();
        if (!rcmd.equals("")) {
            this.run.getModel().addItem(rcmd);
            this.proj.setProperty("console.run", rcmd);
        } else {
            this.proj.removeProperty("console.run");
        }
        String favoriteShell = this.shell.getSelectedItem().toString();
        if (!favoriteShell.equals(this._shell)) {
            this.proj.setProperty("console.shell", favoriteShell);
        }
        String rDir = this.runDir.getTextField().getText();
        if (this.useRunDir.isSelected() && rDir != this._runDir) {
            this.proj.setProperty("console.runDir", rDir);
        } else {
            this.proj.removeProperty("console.runDir");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.runDir.setEnabled(this.useRunDir.isSelected());
    }
}

