/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.Highlight;
import gatchan.highlight.HighlightChangeListener;
import gatchan.highlight.HighlightManager;
import gatchan.highlight.Highlighter;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;

public class HighlightManagerTableModel
extends AbstractTableModel
implements HighlightManager {
    private static final String ENABLED_PROP = "plugin.Highlight.enabled";
    private final List<Highlight> datas = new ArrayList<Highlight>();
    private static HighlightManagerTableModel highlightManagerTableModel;
    private final Collection<HighlightChangeListener> highlightChangeListeners = new ArrayList<HighlightChangeListener>(2);
    private final Path highlightsPath;
    private final ReentrantReadWriteLock lock;
    public static Highlight currentWordHighlight;
    public static Highlight selectionHighlight;
    private boolean highlightWordAtCaret;
    private boolean highlightWordAtCaretEntireWord;
    private boolean highlightWordAtCaretWhitespace;
    private boolean highlightWordAtCaretOnlyWords;
    private boolean highlightSelection;
    private boolean highlightSelectionEntireWord;
    private int highlightSelectionMinLength;
    private int minimumWordLength;
    private boolean appendHighlight = jEdit.getBooleanProperty((String)"gatchan.highlight.appendHighlight");
    public static final String FILE_VERSION = "Highlight file v2";
    private Timer timer;

    static HighlightManager createInstance(@Nullable Path highlightFile) {
        highlightManagerTableModel = new HighlightManagerTableModel(highlightFile);
        return highlightManagerTableModel;
    }

    public static HighlightManagerTableModel getInstance() {
        return highlightManagerTableModel;
    }

    public static HighlightManager getManager() {
        return HighlightManagerTableModel.getInstance();
    }

    private HighlightManagerTableModel(@Nullable Path highlightFile) {
        this.lock = new ReentrantReadWriteLock();
        this.highlightsPath = highlightFile;
        currentWordHighlight = new Highlight();
        selectionHighlight = new Highlight();
        if (this.highlightsPath != null && Files.exists(this.highlightsPath, new LinkOption[0])) {
            try {
                List<String> lines = Files.readAllLines(this.highlightsPath);
                String line = lines.get(0);
                if (FILE_VERSION.equals(line)) {
                    lines.stream().skip(1L).map(Highlight::unserialize).flatMap(Optional::stream).forEach(highlight -> this.addElement((Highlight)highlight, false));
                }
            }
            catch (IOException e) {
                Log.log((int)9, (Object)this, (Object)e);
            }
        }
        this.highlightWordAtCaret = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight");
        this.highlightSelection = jEdit.getBooleanProperty((String)"gatchan.highlight.selectionHighlight");
        this.highlightSelectionEntireWord = jEdit.getBooleanProperty((String)"gatchan.highlight.selectionHighlight.entireWord");
        this.highlightSelectionMinLength = jEdit.getIntegerProperty((String)"gatchan.highlight.selectionHighlight.minLength", (int)0);
        this.highlightWordAtCaretEntireWord = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.entireWord");
        this.highlightWordAtCaretWhitespace = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.whitespace");
        this.highlightWordAtCaretOnlyWords = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.onlyWords");
        currentWordHighlight.init(" ", this.highlightWordAtCaretEntireWord, jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.ignoreCase"), jEdit.getColorProperty((String)"gatchan.highlight.caretHighlight.color"));
        selectionHighlight.init(" ", this.highlightSelectionEntireWord, jEdit.getBooleanProperty((String)"gatchan.highlight.selectionHighlight.ignoreCase"), jEdit.getColorProperty((String)"gatchan.highlight.selectionHighlight.color"));
        currentWordHighlight.setEnabled(false);
        selectionHighlight.setEnabled(false);
        this.timer = new Timer(1000, new RemoveExpired());
        this.timer.start();
    }

    @Override
    public int getRowCount() {
        try {
            this.lock.readLock().lock();
            int n = this.datas.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 0 ? Boolean.class : Highlight.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Highlight highlight;
        try {
            this.lock.readLock().lock();
            highlight = this.datas.get(rowIndex);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (columnIndex == 0) {
            return highlight.isEnabled();
        }
        return highlight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            Highlight highlight;
            try {
                this.lock.readLock().lock();
                highlight = this.datas.get(rowIndex);
            }
            finally {
                this.lock.readLock().unlock();
            }
            highlight.setEnabled((Boolean)aValue);
        } else {
            try {
                this.lock.writeLock().lock();
                this.datas.set(rowIndex, (Highlight)aValue);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public Highlight getHighlight(int i) {
        return this.datas.get(i);
    }

    @Override
    public void addElement(Highlight highlight) {
        this.addElement(highlight, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addElement(Highlight highlight, boolean enable) {
        if (this.indexOf(highlight) == -1) {
            if (this.appendHighlight || this.datas.isEmpty()) {
                int firstRow;
                try {
                    this.lock.writeLock().lock();
                    this.datas.add(highlight);
                    firstRow = this.datas.size() - 1;
                }
                finally {
                    this.lock.writeLock().unlock();
                }
                this.fireTableRowsInserted(firstRow, firstRow);
            } else {
                Highlight replacedHighlight;
                int firstRow;
                try {
                    this.lock.readLock().lock();
                    firstRow = this.datas.size() - 1;
                    replacedHighlight = this.datas.get(firstRow);
                }
                finally {
                    this.lock.readLock().unlock();
                }
                replacedHighlight.init(highlight.getStringToHighlight(), highlight.isRegexp(), highlight.isIgnoreCase(), highlight.getColor());
                this.fireTableRowsUpdated(firstRow, firstRow);
            }
        }
        if (enable) {
            this.setHighlightEnable(true);
        }
    }

    @Override
    public void removeRow(int index) {
        try {
            this.lock.writeLock().lock();
            this.datas.remove(index);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.fireTableRowsDeleted(index, index);
    }

    private void removeRow(Highlight item) {
        int index = this.indexOf(item);
        if (index != -1) {
            this.removeRow(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int indexOf(Highlight highlight) {
        try {
            int i;
            this.lock.readLock().lock();
            int n = i = this.datas.indexOf(highlight);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void bufferClosed(Buffer buffer) {
        Iterable highlights = (Iterable)buffer.getProperty((Object)"highlights");
        if (highlights != null) {
            highlights.forEach(this::removeRow);
        }
    }

    @Override
    public void removeAll() {
        int rowMax;
        try {
            this.lock.writeLock().lock();
            rowMax = this.datas.size();
            this.datas.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (rowMax != 0) {
            this.fireTableRowsDeleted(0, rowMax - 1);
        }
    }

    @Override
    public void dispose() {
        this.timer.stop();
        this.timer = null;
        highlightManagerTableModel = null;
        selectionHighlight = null;
        this.save();
    }

    private void save() {
        if (this.highlightsPath != null) {
            StringBuilder builder = new StringBuilder(FILE_VERSION);
            builder.append('\n');
            try {
                this.lock.writeLock().lock();
                this.datas.stream().filter(highlight -> highlight.getScope() == 0).forEach(highlight -> {
                    builder.append(highlight.serialize());
                    builder.append('\n');
                });
            }
            finally {
                this.lock.writeLock().unlock();
            }
            try {
                Files.writeString(this.highlightsPath, (CharSequence)builder.toString(), new OpenOption[0]);
            }
            catch (IOException e) {
                Log.log((int)9, (Object)this, (Object)"Error while saving highlights", (Throwable)e);
            }
        } else {
            Log.log((int)9, (Object)this, (Object)"No settings");
        }
    }

    @Override
    public void fireTableChanged(TableModelEvent e) {
        super.fireTableChanged(e);
        this.fireHighlightChangeListener(this.isHighlightEnable());
    }

    @Override
    public void addHighlightChangeListener(HighlightChangeListener listener) {
        if (!this.highlightChangeListeners.contains(listener)) {
            this.highlightChangeListeners.add(listener);
        }
    }

    @Override
    public void removeHighlightChangeListener(HighlightChangeListener listener) {
        this.highlightChangeListeners.remove(listener);
    }

    @Override
    public void fireHighlightChangeListener(boolean highlightEnable) {
        this.highlightChangeListeners.forEach(highlightChangeListener -> highlightChangeListener.highlightUpdated(highlightEnable));
    }

    @Override
    public int countHighlights() {
        return this.getRowCount();
    }

    @Override
    public boolean isHighlightEnable() {
        return jEdit.getBooleanProperty((String)ENABLED_PROP);
    }

    @Override
    public void setHighlightEnable(boolean highlightEnable) {
        jEdit.setBooleanProperty((String)ENABLED_PROP, (boolean)highlightEnable);
        this.fireHighlightChangeListener(highlightEnable);
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        JEditTextArea textArea = (JEditTextArea)e.getSource();
        EventQueue.invokeLater(() -> this.caretUpdate(textArea));
    }

    @Override
    public void caretUpdate(JEditTextArea textArea) {
        int line = textArea.getCaretLine();
        boolean updated = false;
        if (this.highlightWordAtCaret) {
            if (textArea.getLineLength(line) == 0 || textArea.getSelectionCount() != 0) {
                if (currentWordHighlight.isEnabled()) {
                    updated = true;
                    currentWordHighlight.setEnabled(false);
                }
            } else {
                int lineStart = textArea.getLineStartOffset(line);
                int offset = textArea.getCaretPosition() - lineStart;
                JEditBuffer buffer = textArea.getBuffer();
                CharSequence lineText = buffer.getLineSegment(line);
                String noWordSep = buffer.getStringProperty("noWordSep");
                if (offset != 0) {
                    --offset;
                }
                int wordStart = TextUtilities.findWordStart((CharSequence)lineText, (int)offset, (String)noWordSep);
                char ch = lineText.charAt(wordStart);
                if (!this.highlightWordAtCaretWhitespace && Character.isWhitespace(ch) || this.highlightWordAtCaretOnlyWords && !Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1) {
                    if (currentWordHighlight.isEnabled()) {
                        updated = true;
                        currentWordHighlight.setEnabled(false);
                    }
                } else {
                    int wordEnd = TextUtilities.findWordEnd((CharSequence)lineText, (int)(offset + 1), (String)noWordSep);
                    if (wordEnd - wordStart < this.minimumWordLength) {
                        if (currentWordHighlight.isEnabled()) {
                            updated = true;
                            currentWordHighlight.setEnabled(false);
                        }
                    } else {
                        if (!currentWordHighlight.isEnabled()) {
                            updated = true;
                            currentWordHighlight.setEnabled(true);
                        }
                        Object stringToHighlight = lineText.subSequence(wordStart, wordEnd).toString();
                        if (this.highlightWordAtCaretEntireWord) {
                            if (!((String)(stringToHighlight = "\\b" + (String)stringToHighlight + "\\b")).equals(currentWordHighlight.getStringToHighlight())) {
                                updated = true;
                                currentWordHighlight.init((String)stringToHighlight, true, currentWordHighlight.isIgnoreCase(), currentWordHighlight.getColor());
                            }
                        } else if (!((String)stringToHighlight).equals(currentWordHighlight.getStringToHighlight())) {
                            updated = true;
                            currentWordHighlight.setStringToHighlight((String)stringToHighlight);
                        }
                    }
                }
            }
        }
        if (this.highlightSelection) {
            if (!selectionHighlight.isEnabled() && !textArea.hasFocus()) {
                updated = true;
                selectionHighlight.setEnabled(true);
            } else {
                Selection selectionatOffset = textArea.getSelectionAtOffset(textArea.getCaretPosition());
                if (textArea.getLineLength(line) == 0 || selectionatOffset == null || selectionatOffset.getStartLine() != selectionatOffset.getEndLine() || selectionatOffset.getEnd() - selectionatOffset.getStart() < this.highlightSelectionMinLength) {
                    if (selectionHighlight.isEnabled()) {
                        updated = true;
                        selectionHighlight.setEnabled(false);
                    }
                } else {
                    Object stringToHighlight = textArea.getSelectedText(selectionatOffset);
                    if (this.highlightSelectionEntireWord) {
                        if (HighlightManagerTableModel.isOnlyWhitespaces((CharSequence)stringToHighlight)) {
                            selectionHighlight.setEnabled(false);
                            updated = true;
                        } else {
                            stringToHighlight = "\\b" + (String)stringToHighlight + "\\b";
                            if (!selectionHighlight.isEnabled() || !((String)stringToHighlight).equals(selectionHighlight.getStringToHighlight())) {
                                updated = true;
                                selectionHighlight.setEnabled(true);
                                selectionHighlight.init((String)stringToHighlight, true, selectionHighlight.isIgnoreCase(), selectionHighlight.getColor());
                            }
                        }
                    } else if (!selectionHighlight.isEnabled() || !((String)stringToHighlight).equals(selectionHighlight.getStringToHighlight())) {
                        updated = true;
                        selectionHighlight.setEnabled(true);
                        selectionHighlight.setStringToHighlight((String)stringToHighlight);
                    }
                }
            }
        }
        if (updated) {
            this.fireHighlightChangeListener(this.isHighlightEnable());
        }
    }

    @Override
    public boolean isHighlightWordAtCaret() {
        return this.highlightWordAtCaret;
    }

    @Override
    public boolean isHighlightSelection() {
        return this.highlightSelection;
    }

    @Override
    public void propertiesChanged() {
        int minimumWordLength;
        int selectionMinLength;
        boolean selectionEntireWord;
        boolean onlyWords;
        boolean whitespace;
        boolean entireWord;
        boolean highlightSelection;
        if (jEdit.getBooleanProperty((String)"gatchan.highlight.cycleColor")) {
            Highlight.setDefaultColor(null);
        } else {
            Highlight.setDefaultColor(jEdit.getColorProperty((String)"gatchan.highlight.defaultColor"));
        }
        this.appendHighlight = jEdit.getBooleanProperty((String)"gatchan.highlight.appendHighlight");
        boolean changed = false;
        boolean changedSelection = false;
        boolean shouldUpdateCaret = false;
        boolean highlightWordAtCaret = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight");
        if (this.highlightWordAtCaret != highlightWordAtCaret) {
            changed = true;
            this.highlightWordAtCaret = highlightWordAtCaret;
            currentWordHighlight.setEnabled(highlightWordAtCaret);
            if (highlightWordAtCaret) {
                shouldUpdateCaret = true;
            }
        }
        if (this.highlightSelection != (highlightSelection = jEdit.getBooleanProperty((String)"gatchan.highlight.selectionHighlight"))) {
            changedSelection = true;
            this.highlightSelection = highlightSelection;
            selectionHighlight.setEnabled(highlightSelection);
            if (highlightSelection) {
                shouldUpdateCaret = true;
            }
        }
        if (shouldUpdateCaret) {
            this.caretUpdate(jEdit.getActiveView().getTextArea());
        }
        if (this.highlightWordAtCaretEntireWord != (entireWord = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.entireWord"))) {
            changed = true;
            this.highlightWordAtCaretEntireWord = entireWord;
            if (entireWord) {
                String s = currentWordHighlight.getStringToHighlight();
                currentWordHighlight.setStringToHighlight("\\b" + s + "\\b");
            }
        }
        if (this.highlightWordAtCaretWhitespace != (whitespace = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.whitespace"))) {
            changed = true;
            this.highlightWordAtCaretWhitespace = whitespace;
        }
        if (this.highlightWordAtCaretOnlyWords != (onlyWords = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.onlyWords"))) {
            changed = true;
            this.highlightWordAtCaretOnlyWords = onlyWords;
        }
        boolean ignoreCase = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.ignoreCase");
        if (currentWordHighlight.isIgnoreCase() != ignoreCase) {
            changed = true;
        }
        boolean selectionIgnoreCase = jEdit.getBooleanProperty((String)"gatchan.highlight.selectionHighlight.ignoreCase");
        if (selectionHighlight.isIgnoreCase() != ignoreCase) {
            changedSelection = true;
        }
        Color newColor = jEdit.getColorProperty((String)"gatchan.highlight.caretHighlight.color");
        if (!currentWordHighlight.getColor().equals(newColor)) {
            changed = true;
        }
        if (this.highlightSelectionEntireWord != (selectionEntireWord = jEdit.getBooleanProperty((String)"gatchan.highlight.selectionHighlight.entireWord"))) {
            changed = true;
            this.highlightSelectionEntireWord = selectionEntireWord;
            if (selectionEntireWord) {
                String s = selectionHighlight.getStringToHighlight();
                if (HighlightManagerTableModel.isOnlyWhitespaces(s)) {
                    selectionHighlight.setEnabled(false);
                }
                selectionHighlight.setStringToHighlight("\\b" + s + "\\b");
            }
        }
        if (this.highlightSelectionMinLength != (selectionMinLength = jEdit.getIntegerProperty((String)"gatchan.highlight.selectionHighlight.minLength", (int)0))) {
            changed = true;
            this.highlightSelectionMinLength = selectionMinLength;
        }
        Color selectionNewColor = jEdit.getColorProperty((String)"gatchan.highlight.selectionHighlight.color");
        if (!selectionHighlight.getColor().equals(selectionNewColor)) {
            changedSelection = true;
        }
        if (this.minimumWordLength != (minimumWordLength = jEdit.getIntegerProperty((String)"gatchan.highlight.wordMinimumLength", (int)2))) {
            changed = true;
            this.minimumWordLength = minimumWordLength;
        }
        Highlighter.square = jEdit.getBooleanProperty((String)"gatchan.highlight.square");
        Highlighter.squareColor = jEdit.getColorProperty((String)"gatchan.highlight.square.color");
        if (changed) {
            currentWordHighlight.init(currentWordHighlight.getStringToHighlight(), entireWord, ignoreCase, newColor);
        }
        if (changedSelection) {
            selectionHighlight.init(selectionHighlight.getStringToHighlight(), false, selectionIgnoreCase, selectionNewColor);
        }
        if (changed || changedSelection) {
            this.fireHighlightChangeListener(this.isHighlightEnable());
        }
    }

    @Override
    public void getReadLock() {
        this.lock.readLock().lock();
    }

    @Override
    public void releaseLock() {
        this.lock.readLock().unlock();
    }

    public static boolean isOnlyWhitespaces(CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private class RemoveExpired
    implements ActionListener {
        private RemoveExpired() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Highlight> expired;
            try {
                HighlightManagerTableModel.this.lock.readLock().lock();
                expired = HighlightManagerTableModel.this.datas.stream().filter(Highlight::isExpired).collect(Collectors.toList());
            }
            finally {
                HighlightManagerTableModel.this.lock.readLock().unlock();
            }
            expired.forEach(x$0 -> HighlightManagerTableModel.this.removeRow((Highlight)x$0));
        }
    }
}

