/*
 * Decompiled with CFR 0.152.
 */
package errorlist;

import errorlist.ErrorSource;
import errorlist.ErrorSourceUpdate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import javax.swing.text.Position;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;

public class DefaultErrorSource
extends ErrorSource {
    public static final String[] EMPTY_STRING = new String[0];
    public static final ErrorSource.Error[] EMPTY_ERROR_ARRAY = new ErrorSource.Error[0];
    protected String name;
    protected View view;
    protected int errorCount;
    protected Map<String, ErrorListForPath> errors = new LinkedHashMap<String, ErrorListForPath>();
    private boolean addedToBus;

    public DefaultErrorSource(String name, View v) {
        this.name = name;
        this.view = v;
    }

    @Deprecated
    public DefaultErrorSource(String name) {
        this(name, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public View getView() {
        return this.view;
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public synchronized ErrorSource.Error[] getAllErrors() {
        if (this.errors.isEmpty()) {
            return null;
        }
        LinkedList errorList = new LinkedList();
        this.errors.values().forEach(errorList::addAll);
        return errorList.toArray(EMPTY_ERROR_ARRAY);
    }

    @Override
    public int getFileErrorCount(String path) {
        ErrorListForPath list = this.errors.get(path);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    @Override
    public ErrorSource.Error[] getFileErrors(String path) {
        ErrorListForPath list = this.errors.get(path);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.toArray(EMPTY_ERROR_ARRAY);
    }

    @Override
    public ErrorSource.Error[] getLineErrors(String path, int startLineIndex, int endLineIndex) {
        if (this.errors.isEmpty()) {
            return null;
        }
        ErrorListForPath list = this.errors.get(path);
        if (list == null) {
            return null;
        }
        Collection<ErrorSource.Error> inRange = list.subSetInLineRange(startLineIndex, endLineIndex);
        if (inRange.isEmpty()) {
            return null;
        }
        return inRange.toArray(EMPTY_ERROR_ARRAY);
    }

    public synchronized void clear() {
        if (this.errorCount == 0) {
            return;
        }
        this.errors.clear();
        this.errorCount = 0;
        this.removeOrAddToBus();
        if (this.registered) {
            SwingUtilities.invokeLater(() -> this.sendErrorSourceUpdate(ErrorSourceUpdate.ERRORS_CLEARED));
        }
    }

    public synchronized void removeFileErrors(String path) {
        ErrorListForPath list = this.errors.remove(path);
        if (list == null) {
            return;
        }
        this.errorCount -= list.size();
        this.removeOrAddToBus();
        if (this.registered) {
            SwingUtilities.invokeLater(() -> list.forEach(error -> this.sendErrorSourceUpdate(ErrorSourceUpdate.ERROR_REMOVED, (ErrorSource.Error)error)));
        }
    }

    @Override
    public synchronized void addError(DefaultError error) {
        ErrorListForPath list = this.errors.get(error.getFilePath());
        if (list == null) {
            list = new ErrorListForPath();
            this.errors.put(error.getFilePath(), list);
        }
        if (list.add(error)) {
            ++this.errorCount;
            this.removeOrAddToBus();
            if (this.registered) {
                SwingUtilities.invokeLater(() -> this.sendErrorSourceUpdate(ErrorSourceUpdate.ERROR_ADDED, error));
            }
        }
    }

    public void addError(int type, String path, int lineIndex, int start, int end, String error) {
        DefaultError newError = new DefaultError(this, type, path, lineIndex, start, end, error);
        this.addError(newError);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.name + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DefaultErrorSource)) {
            return false;
        }
        DefaultErrorSource other = (DefaultErrorSource)o;
        if (this.getView() != null && !this.getView().equals(other.getView())) {
            return false;
        }
        if (this.getName() != null && !this.getName().equals(other.getName())) {
            return false;
        }
        return this.getErrorCount() == other.getErrorCount();
    }

    @Override
    public int hashCode() {
        int hc = 0;
        if (this.getView() != null) {
            hc += this.getView().hashCode();
        }
        if (this.getName() != null) {
            hc += this.getName().hashCode();
        }
        return hc += this.getErrorCount() * 13;
    }

    @EditBus.EBHandler
    public synchronized void handleBufferMessage(BufferUpdate message) {
        ErrorListForPath list;
        Buffer buffer = message.getBuffer();
        if (message.getWhat() == BufferUpdate.LOADED) {
            ErrorListForPath list2 = this.errors.get(buffer.getSymlinkPath());
            if (list2 != null) {
                list2.forEach(error -> ((DefaultError)error).openNotify(buffer));
            }
        } else if (message.getWhat() == BufferUpdate.CLOSED && (list = this.errors.get(buffer.getSymlinkPath())) != null) {
            list.forEach(error -> ((DefaultError)error).closeNotify(buffer));
        }
    }

    protected void removeOrAddToBus() {
        if (this.addedToBus && this.errorCount == 0) {
            this.addedToBus = false;
            EditBus.removeFromBus((Object)this);
        } else if (!this.addedToBus && this.errorCount != 0) {
            this.addedToBus = true;
            EditBus.addToBus((Object)this);
        }
    }

    private void sendErrorSourceUpdate(Object what) {
        EditBus.send((EBMessage)new ErrorSourceUpdate(this, what));
    }

    private void sendErrorSourceUpdate(Object what, ErrorSource.Error error) {
        EditBus.send((EBMessage)new ErrorSourceUpdate((ErrorSource)this, what, error));
    }

    protected static class ErrorListForPath
    extends TreeSet<ErrorSource.Error> {
        public ErrorListForPath() {
            super(new ErrorComparator());
        }

        public Collection<ErrorSource.Error> subSetInLineRange(int start, int end) {
            return this.subSet(new LineKey(start), new LineKey(end + 1));
        }

        private static class LineKey
        implements ErrorSource.Error {
            private final int line;

            LineKey(int line) {
                this.line = line;
            }

            @Override
            public int getLineNumber() {
                return this.line;
            }

            @Override
            public String getErrorMessage() {
                return "";
            }

            @Override
            public int getErrorType() {
                return 0;
            }

            @Override
            public ErrorSource getErrorSource() {
                return null;
            }

            @Override
            public Buffer getBuffer() {
                return null;
            }

            @Override
            public String getFilePath() {
                return null;
            }

            @Override
            public String getFileName() {
                return null;
            }

            @Override
            public int getStartOffset() {
                return 0;
            }

            @Override
            public int getEndOffset() {
                return 0;
            }

            @Override
            public String[] getExtraMessages() {
                return null;
            }
        }

        private static class ErrorComparator
        implements Comparator<ErrorSource.Error> {
            private ErrorComparator() {
            }

            @Override
            public int compare(ErrorSource.Error e1, ErrorSource.Error e2) {
                int o2;
                int line2;
                int line1 = e1.getLineNumber();
                if (line1 < (line2 = e2.getLineNumber())) {
                    return -1;
                }
                if (line1 > line2) {
                    return 1;
                }
                int o1 = e1.getStartOffset();
                if (o1 < (o2 = e2.getStartOffset())) {
                    return -1;
                }
                if (o1 > o2) {
                    return 1;
                }
                o1 = e1.getEndOffset();
                if (o1 < (o2 = e2.getEndOffset())) {
                    return -1;
                }
                if (o1 > o2) {
                    return 1;
                }
                String message1 = e1.getErrorMessage();
                String message2 = e2.getErrorMessage();
                int message_sign = message1 == null ? (message2 == null ? 0 : -1) : (message2 == null ? 1 : message1.compareTo(message2));
                if (message_sign != 0) {
                    return message_sign;
                }
                return 0;
            }
        }
    }

    public static class DefaultError
    implements ErrorSource.Error {
        DefaultError next;
        private final ErrorSource source;
        private final int type;
        private String path;
        private String name;
        private Buffer buffer;
        private final int lineIndex;
        private int start;
        private final int end;
        private Position linePos;
        private Position startPos;
        private Position endPos;
        private final String error;
        private List<String> extras;

        public DefaultError(ErrorSource source, int type, String path, int lineIndex, int start, int end, String error) {
            this.source = source;
            this.type = type;
            this.setFilePath(path);
            this.lineIndex = lineIndex;
            this.start = start;
            this.end = end;
            this.error = error;
            Buffer buffer = jEdit.getBuffer((String)this.path);
            if (buffer != null && buffer.isLoaded()) {
                this.openNotify(buffer);
            }
        }

        @Override
        public ErrorSource getErrorSource() {
            return this.source;
        }

        @Override
        public int getErrorType() {
            return this.type;
        }

        @Override
        public Buffer getBuffer() {
            return this.buffer;
        }

        @Override
        public String getFilePath() {
            return this.path;
        }

        public void setFilePath(String newPath) {
            this.path = MiscUtilities.resolveSymlinks((String)newPath);
            this.name = MiscUtilities.getFileName((String)this.path);
        }

        @Override
        public String getFileName() {
            return this.name;
        }

        @Override
        public int getLineNumber() {
            if (this.startPos != null) {
                return this.buffer.getLineOfOffset(this.startPos.getOffset());
            }
            return this.lineIndex;
        }

        @Override
        public int getStartOffset() {
            if (this.startPos != null) {
                return this.startPos.getOffset() - this.buffer.getLineStartOffset(this.getLineNumber());
            }
            return this.start;
        }

        @Override
        public int getEndOffset() {
            if (this.endPos != null) {
                return this.endPos.getOffset() - this.buffer.getLineStartOffset(this.getLineNumber());
            }
            return this.end;
        }

        @Override
        public String getErrorMessage() {
            return this.error;
        }

        public void addExtraMessage(String message) {
            if (this.extras == null) {
                this.extras = new ArrayList<String>();
            }
            this.extras.add(message);
        }

        @Override
        public String[] getExtraMessages() {
            if (this.extras == null) {
                return EMPTY_STRING;
            }
            return this.extras.toArray(EMPTY_STRING);
        }

        public String toString() {
            return this.getFileName() + ":" + (this.getLineNumber() + 1) + ":" + this.getErrorMessage();
        }

        public boolean equals(Object o) {
            if (!(o instanceof DefaultError)) {
                return false;
            }
            DefaultError other = (DefaultError)o;
            if (this.getBuffer() != null && !this.getBuffer().equals(other.getBuffer())) {
                return false;
            }
            if (this.getEndOffset() != other.getEndOffset()) {
                return false;
            }
            if (this.getStartOffset() != other.getStartOffset()) {
                return false;
            }
            if (this.getLineNumber() != other.getLineNumber()) {
                return false;
            }
            if (this.getFileName() != null && !this.getFileName().equals(other.getFileName())) {
                return false;
            }
            return this.getFilePath() == null || this.getFilePath().equals(other.getFilePath());
        }

        public int hashCode() {
            int hc = 0;
            if (this.getBuffer() != null) {
                hc += this.getBuffer().hashCode();
            }
            hc += this.getEndOffset() * 19;
            hc += this.getStartOffset() * 23;
            hc += this.getLineNumber() * 29;
            if (this.getFileName() != null) {
                hc += this.getFileName().hashCode();
            }
            if (this.getFilePath() != null) {
                hc += this.getFilePath().hashCode();
            }
            return hc;
        }

        void openNotify(Buffer buffer) {
            this.buffer = buffer;
            int lineIndex = Math.min(this.lineIndex, buffer.getLineCount() - 1);
            this.start = Math.min(this.start, buffer.getLineLength(lineIndex));
            int lineStart = buffer.getLineStartOffset(lineIndex);
            this.startPos = buffer.createPosition(lineStart + this.start);
            this.endPos = this.end != 0 ? buffer.createPosition(lineStart + this.end) : null;
        }

        void closeNotify(Buffer buffer) {
            this.buffer = null;
            this.linePos = null;
            this.startPos = null;
            this.endPos = null;
        }
    }
}

