/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.config;

import java.util.List;
import net.sf.launch4j.binding.IValidatable;
import net.sf.launch4j.binding.Validator;
import net.sf.launch4j.config.JreVersion;
import net.sf.launch4j.config.Messages;

public class Jre
implements IValidatable {
    public static final String VERSION_PATTERN = "(1\\.\\d\\.\\d(_\\d{1,3})?)|[1-9][0-9]{0,2}(\\.\\d{1,3}){0,2}";
    public static final String DEFAULT_PATH = "%JAVA_HOME%;%PATH%";
    private String path;
    private boolean requiresJdk;
    private boolean requires64Bit;
    private String minVersion;
    private String maxVersion;
    private Integer initialHeapSize;
    private Integer initialHeapPercent;
    private Integer maxHeapSize;
    private Integer maxHeapPercent;
    private List<String> options;

    @Override
    public void checkInvariants() {
        Validator.checkOptString(this.minVersion, 20, VERSION_PATTERN, "jre.minVersion", Messages.getString("Jre.min.version"));
        Validator.checkOptString(this.maxVersion, 20, VERSION_PATTERN, "jre.maxVersion", Messages.getString("Jre.max.version"));
        Validator.checkString(this.path, 260, "jre.path", Messages.getString("Jre.path"));
        if (!Validator.isEmpty(this.maxVersion)) {
            Validator.checkFalse(Validator.isEmpty(this.minVersion), "jre.minVersion", Messages.getString("Jre.specify.min.version"));
            Validator.checkTrue(JreVersion.parseString(this.minVersion).compareTo(JreVersion.parseString(this.maxVersion)) < 0, "jre.maxVersion", Messages.getString("Jre.max.greater.than.min"));
        }
        Validator.checkTrue(this.initialHeapSize == null || this.maxHeapSize != null, "jre.maxHeapSize", Messages.getString("Jre.initial.and.max.heap"));
        Validator.checkTrue(this.initialHeapSize == null || this.initialHeapSize > 0, "jre.initialHeapSize", Messages.getString("Jre.initial.heap"));
        Validator.checkTrue(this.maxHeapSize == null || this.maxHeapSize >= (this.initialHeapSize != null ? this.initialHeapSize : 1), "jre.maxHeapSize", Messages.getString("Jre.max.heap"));
        Validator.checkTrue(this.initialHeapPercent == null || this.maxHeapPercent != null, "jre.maxHeapPercent", Messages.getString("Jre.initial.and.max.heap"));
        if (this.initialHeapPercent != null) {
            Validator.checkRange(this.initialHeapPercent, 1, 100, "jre.initialHeapPercent", Messages.getString("Jre.initial.heap.percent"));
        }
        if (this.maxHeapPercent != null) {
            Validator.checkRange(this.maxHeapPercent, this.initialHeapPercent != null ? this.initialHeapPercent : 1, 100, "jre.maxHeapPercent", Messages.getString("Jre.max.heap.percent"));
        }
        Validator.checkOptStrings(this.options, 30719, 30719, "[^\"]*|([^\"]*\"[^\"]*\"[^\"]*)*", "jre.options", Messages.getString("Jre.jvm.options"), Messages.getString("Jre.jvm.options.unclosed.quotation"));
        Validator.checkOptStrings(this.options, 30719, 30719, "[^%]*|([^%]*([^%]*%[^%]*%[^%]*)+[^%]*)*", "jre.options", Messages.getString("Jre.jvm.options"), Messages.getString("Jre.jvm.options.variable"));
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }

    public String getMaxVersion() {
        return this.maxVersion;
    }

    public void setMaxVersion(String maxVersion) {
        this.maxVersion = maxVersion;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public void setMinVersion(String minVersion) {
        this.minVersion = minVersion;
    }

    public boolean getRequiresJdk() {
        return this.requiresJdk;
    }

    public void setRequiresJdk(boolean requiresJdk) {
        this.requiresJdk = requiresJdk;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean getRequires64Bit() {
        return this.requires64Bit;
    }

    public void setRequires64Bit(boolean requires64Bit) {
        this.requires64Bit = requires64Bit;
    }

    public Integer getInitialHeapSize() {
        return this.initialHeapSize;
    }

    public void setInitialHeapSize(Integer initialHeapSize) {
        this.initialHeapSize = this.getInteger(initialHeapSize);
    }

    public Integer getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public void setMaxHeapSize(Integer maxHeapSize) {
        this.maxHeapSize = this.getInteger(maxHeapSize);
    }

    public Integer getInitialHeapPercent() {
        return this.initialHeapPercent;
    }

    public void setInitialHeapPercent(Integer initialHeapPercent) {
        this.initialHeapPercent = this.getInteger(initialHeapPercent);
    }

    public Integer getMaxHeapPercent() {
        return this.maxHeapPercent;
    }

    public void setMaxHeapPercent(Integer maxHeapPercent) {
        this.maxHeapPercent = this.getInteger(maxHeapPercent);
    }

    private Integer getInteger(Integer i) {
        return i != null && i == 0 ? null : i;
    }
}

